/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.tool;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;
import org.apache.avro.Schema;
import org.apache.avro.file.DataFileReader;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.io.DatumReader;
import org.apache.avro.tool.FromTextTool;
import org.apache.avro.tool.ToTextTool;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class TestTextFileTools {
    private static final int COUNT = Integer.parseInt(System.getProperty("test.count", "10"));
    private static final byte[] LINE_SEP = System.getProperty("line.separator").getBytes(StandardCharsets.UTF_8);
    private static File linesFile;
    private static ByteBuffer[] lines;
    static Schema schema;
    @ClassRule
    public static TemporaryFolder DIR;

    static {
        DIR = new TemporaryFolder();
    }

    @BeforeClass
    public static void writeRandomFile() throws IOException {
        schema = Schema.create((Schema.Type)Schema.Type.BYTES);
        lines = new ByteBuffer[COUNT];
        linesFile = new File(DIR.getRoot(), "random.lines");
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(linesFile));
        Random rand = new Random();
        int j = 0;
        while (j < COUNT) {
            byte[] line = new byte[rand.nextInt(512)];
            System.out.println("Creating line = " + line.length);
            int i = 0;
            while (i < line.length) {
                int b = rand.nextInt(256);
                while (b == 10 || b == 13) {
                    b = rand.nextInt(256);
                }
                line[i] = (byte)b;
                ++i;
            }
            ((OutputStream)out).write(line);
            ((OutputStream)out).write(LINE_SEP);
            TestTextFileTools.lines[j] = ByteBuffer.wrap(line);
            ++j;
        }
        ((OutputStream)out).close();
    }

    private void fromText(String name, String ... args) throws Exception {
        File avroFile = new File(DIR.getRoot(), String.valueOf(name) + ".avro");
        ArrayList<String> arglist = new ArrayList<String>(Arrays.asList(args));
        arglist.add(linesFile.toString());
        arglist.add(avroFile.toString());
        new FromTextTool().run(null, null, null, arglist);
        DataFileReader file = new DataFileReader(avroFile, (DatumReader)new GenericDatumReader());
        int i = 0;
        for (ByteBuffer line : file) {
            System.out.println("Reading line = " + line.remaining());
            Assert.assertEquals((Object)line, (Object)lines[i]);
            ++i;
        }
        Assert.assertEquals((long)COUNT, (long)i);
    }

    @Test
    public void testFromText() throws Exception {
        this.fromText("null", "--codec", "null");
        this.fromText("deflate", "--codec", "deflate");
        this.fromText("snappy", "--codec", "snappy");
    }

    @AfterClass
    public static void testToText() throws Exception {
        TestTextFileTools.toText("null");
        TestTextFileTools.toText("deflate");
        TestTextFileTools.toText("snappy");
    }

    private static void toText(String name) throws Exception {
        File avroFile = new File(DIR.getRoot(), String.valueOf(name) + ".avro");
        File outFile = new File(DIR.getRoot(), String.valueOf(name) + ".lines");
        ArrayList<String> arglist = new ArrayList<String>();
        arglist.add(avroFile.toString());
        arglist.add(outFile.toString());
        new ToTextTool().run(null, null, null, arglist);
        Throwable throwable = null;
        Object var5_6 = null;
        try (BufferedInputStream orig = new BufferedInputStream(new FileInputStream(linesFile));){
            Throwable throwable2 = null;
            Object var8_11 = null;
            try (BufferedInputStream after = new BufferedInputStream(new FileInputStream(outFile));){
                int b;
                while ((b = ((InputStream)orig).read()) != -1) {
                    Assert.assertEquals((long)b, (long)((InputStream)after).read());
                }
                Assert.assertEquals((long)-1L, (long)((InputStream)after).read());
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                } else if (throwable2 != throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }
}

