/*
 * Decompiled with CFR 0.152.
 */
package org.apache.trevni;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.trevni.BlockDescriptor;
import org.apache.trevni.Checksum;
import org.apache.trevni.Codec;
import org.apache.trevni.ColumnFileWriter;
import org.apache.trevni.ColumnMetaData;
import org.apache.trevni.OutputBuffer;
import org.apache.trevni.TrevniRuntimeException;

class ColumnOutputBuffer {
    private ColumnFileWriter writer;
    private ColumnMetaData meta;
    private Codec codec;
    private Checksum checksum;
    private OutputBuffer buffer;
    private List<BlockDescriptor> blockDescriptors;
    private List<byte[]> blockData;
    private List<byte[]> firstValues;
    private int rowCount;
    private long size = 4L;

    public ColumnOutputBuffer(ColumnFileWriter writer, ColumnMetaData meta) throws IOException {
        this.writer = writer;
        this.meta = meta;
        this.codec = Codec.get(meta);
        this.checksum = Checksum.get(meta);
        this.buffer = new OutputBuffer();
        this.blockDescriptors = new ArrayList<BlockDescriptor>();
        this.blockData = new ArrayList<byte[]>();
        if (meta.hasIndexValues()) {
            this.firstValues = new ArrayList<byte[]>();
        }
    }

    public ColumnMetaData getMeta() {
        return this.meta;
    }

    public OutputBuffer getBuffer() {
        return this.buffer;
    }

    public void startRow() throws IOException {
        if (this.buffer.isFull()) {
            this.flushBuffer();
        }
    }

    public void writeLength(int length) throws IOException {
        throw new TrevniRuntimeException("Not an array column: " + this.meta);
    }

    public void writeValue(Object value) throws IOException {
        this.buffer.writeValue(value, this.meta.getType());
        if (this.meta.hasIndexValues() && this.rowCount == 0) {
            this.firstValues.add(this.buffer.toByteArray());
        }
    }

    public void endRow() throws IOException {
        ++this.rowCount;
    }

    void flushBuffer() throws IOException {
        if (this.rowCount == 0) {
            return;
        }
        ByteBuffer raw = this.buffer.asByteBuffer();
        ByteBuffer c = this.codec.compress(raw);
        this.blockDescriptors.add(new BlockDescriptor(this.rowCount, raw.remaining(), c.remaining()));
        ByteBuffer data = ByteBuffer.allocate(c.remaining() + this.checksum.size());
        data.put(c);
        data.put(this.checksum.compute(raw));
        this.blockData.add(data.array());
        int sizeIncrement = 12 + (this.firstValues != null ? this.firstValues.get(this.firstValues.size() - 1).length : 0) + data.position();
        this.writer.incrementSize(sizeIncrement);
        this.size += (long)sizeIncrement;
        this.buffer = new OutputBuffer();
        this.rowCount = 0;
    }

    public long size() throws IOException {
        this.flushBuffer();
        return this.size;
    }

    public void writeTo(OutputStream out) throws IOException {
        OutputBuffer header = new OutputBuffer();
        header.writeFixed32(this.blockDescriptors.size());
        int i = 0;
        while (i < this.blockDescriptors.size()) {
            this.blockDescriptors.get(i).writeTo(header);
            if (this.meta.hasIndexValues()) {
                header.write(this.firstValues.get(i));
            }
            ++i;
        }
        header.writeTo(out);
        for (byte[] data : this.blockData) {
            out.write(data);
        }
    }
}

