/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.tool;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.List;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import org.apache.avro.Schema;
import org.apache.avro.file.CodecFactory;
import org.apache.avro.file.DataFileStream;
import org.apache.avro.file.DataFileWriter;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.tool.Tool;
import org.apache.avro.tool.Util;

public class RecodecTool
implements Tool {
    @Override
    public int run(InputStream in, PrintStream out, PrintStream err, List<String> args) throws Exception {
        OptionParser optParser = new OptionParser();
        OptionSpec<String> codecOpt = Util.compressionCodecOptionWithDefault(optParser, "null");
        OptionSpec<Integer> levelOpt = Util.compressionLevelOption(optParser);
        OptionSet opts = optParser.parse(args.toArray(new String[0]));
        List nargs = opts.nonOptionArguments();
        if (nargs.size() > 2) {
            err.println("Expected at most an input file and output file.");
            optParser.printHelpOn((OutputStream)err);
            return 1;
        }
        InputStream input = in;
        boolean inputNeedsClosing = false;
        if (nargs.size() > 0 && !((String)nargs.get(0)).equals("-")) {
            input = Util.openFromFS((String)nargs.get(0));
            inputNeedsClosing = true;
        }
        OutputStream output = out;
        boolean outputNeedsClosing = false;
        if (nargs.size() > 1 && !((String)nargs.get(1)).equals("-")) {
            output = Util.createFromFS((String)nargs.get(1));
            outputNeedsClosing = true;
        }
        DataFileStream reader = new DataFileStream(input, (DatumReader)new GenericDatumReader());
        Schema schema = reader.getSchema();
        DataFileWriter writer = new DataFileWriter((DatumWriter)new GenericDatumWriter());
        CodecFactory codec = Util.codecFactory(opts, codecOpt, levelOpt, "null");
        writer.setCodec(codec);
        for (String key : reader.getMetaKeys()) {
            if (DataFileWriter.isReservedMeta((String)key)) continue;
            writer.setMeta(key, reader.getMeta(key));
        }
        writer.create(schema, output);
        writer.appendAllFrom(reader, true);
        writer.flush();
        if (inputNeedsClosing) {
            input.close();
        }
        if (outputNeedsClosing) {
            output.close();
        }
        return 0;
    }

    @Override
    public String getName() {
        return "recodec";
    }

    @Override
    public String getShortDescription() {
        return "Alters the codec of a data file.";
    }
}

