/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import com.google.common.base.Preconditions;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.InvalidPathException;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.ParentNotDirectoryException;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.protocol.FSLimitException;
import org.apache.hadoop.hdfs.protocol.HdfsFileStatus;
import org.apache.hadoop.hdfs.protocol.QuotaExceededException;
import org.apache.hadoop.hdfs.protocol.SnapshotException;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockStoragePolicySuite;
import org.apache.hadoop.hdfs.server.namenode.FSDirDeleteOp;
import org.apache.hadoop.hdfs.server.namenode.FSDirSnapshotOp;
import org.apache.hadoop.hdfs.server.namenode.FSDirectory;
import org.apache.hadoop.hdfs.server.namenode.FSPermissionChecker;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.hdfs.server.namenode.INodeDirectory;
import org.apache.hadoop.hdfs.server.namenode.INodeReference;
import org.apache.hadoop.hdfs.server.namenode.INodesInPath;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.QuotaCounts;
import org.apache.hadoop.hdfs.util.ReadOnlyList;
import org.apache.hadoop.util.ChunkedArrayList;
import org.apache.hadoop.util.Time;

class FSDirRenameOp {
    FSDirRenameOp() {
    }

    @Deprecated
    static RenameOldResult renameToInt(FSDirectory fsd, String srcArg, String dstArg, boolean logRetryCache) throws IOException {
        String src = srcArg;
        String dst = dstArg;
        if (NameNode.stateChangeLog.isDebugEnabled()) {
            NameNode.stateChangeLog.debug("DIR* NameSystem.renameTo: " + src + " to " + dst);
        }
        if (!DFSUtil.isValidName(dst)) {
            throw new IOException("Invalid name: " + dst);
        }
        FSPermissionChecker pc = fsd.getPermissionChecker();
        byte[][] srcComponents = FSDirectory.getPathComponentsForReservedPath(src);
        byte[][] dstComponents = FSDirectory.getPathComponentsForReservedPath(dst);
        HdfsFileStatus resultingStat = null;
        boolean status = FSDirRenameOp.renameTo(fsd, pc, src = fsd.resolvePath(pc, src, srcComponents), dst = fsd.resolvePath(pc, dst, dstComponents), logRetryCache);
        if (status) {
            INodesInPath dstIIP = fsd.getINodesInPath(dst, false);
            resultingStat = fsd.getAuditFileInfo(dstIIP);
        }
        return new RenameOldResult(status, resultingStat);
    }

    private static void verifyQuotaForRename(FSDirectory fsd, INodesInPath src, INodesInPath dst) throws QuotaExceededException {
        if (!fsd.getFSNamesystem().isImageLoaded() || fsd.shouldSkipQuotaChecks()) {
            return;
        }
        int i = 0;
        while (src.getINode(i) == dst.getINode(i)) {
            ++i;
        }
        BlockStoragePolicySuite bsps = fsd.getBlockStoragePolicySuite();
        QuotaCounts delta = src.getLastINode().computeQuotaUsage(bsps);
        INode dstINode = dst.getLastINode();
        if (dstINode != null) {
            delta.subtract(dstINode.computeQuotaUsage(bsps));
        }
        FSDirectory.verifyQuota(dst, dst.length() - 1, delta, src.getINode(i - 1));
    }

    static void verifyFsLimitsForRename(FSDirectory fsd, INodesInPath srcIIP, INodesInPath dstIIP) throws FSLimitException.PathComponentTooLongException, FSLimitException.MaxDirectoryItemsExceededException {
        byte[] dstChildName = dstIIP.getLastLocalName();
        String parentPath = dstIIP.getParentPath();
        fsd.verifyMaxComponentLength(dstChildName, parentPath);
        if (srcIIP.getINode(-2) != dstIIP.getINode(-2)) {
            fsd.verifyMaxDirItems(dstIIP.getINode(-2).asDirectory(), parentPath);
        }
    }

    @Deprecated
    static boolean renameForEditLog(FSDirectory fsd, String src, String dst, long timestamp) throws IOException {
        if (fsd.isDir(dst)) {
            dst = dst + "/" + new Path(src).getName();
        }
        INodesInPath srcIIP = fsd.getINodesInPath4Write(src, false);
        INodesInPath dstIIP = fsd.getINodesInPath4Write(dst, false);
        return FSDirRenameOp.unprotectedRenameTo(fsd, src, dst, srcIIP, dstIIP, timestamp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    static boolean unprotectedRenameTo(FSDirectory fsd, String src, String dst, INodesInPath srcIIP, INodesInPath dstIIP, long timestamp) throws IOException {
        assert (fsd.hasWriteLock());
        INode srcInode = srcIIP.getLastINode();
        try {
            FSDirRenameOp.validateRenameSource(srcIIP);
        }
        catch (SnapshotException e) {
            throw e;
        }
        catch (IOException ignored) {
            return false;
        }
        if (dst.equals(src)) {
            return true;
        }
        try {
            FSDirRenameOp.validateDestination(src, dst, srcInode);
        }
        catch (IOException ignored) {
            return false;
        }
        if (dstIIP.getLastINode() != null) {
            NameNode.stateChangeLog.warn("DIR* FSDirectory.unprotectedRenameTo: failed to rename " + src + " to " + dst + " because destination " + "exists");
            return false;
        }
        INode dstParent = dstIIP.getINode(-2);
        if (dstParent == null) {
            NameNode.stateChangeLog.warn("DIR* FSDirectory.unprotectedRenameTo: failed to rename " + src + " to " + dst + " because destination's " + "parent does not exist");
            return false;
        }
        fsd.ezManager.checkMoveValidity(srcIIP, dstIIP, src);
        FSDirRenameOp.verifyFsLimitsForRename(fsd, srcIIP, dstIIP);
        FSDirRenameOp.verifyQuotaForRename(fsd, srcIIP, dstIIP);
        RenameOperation tx = new RenameOperation(fsd, src, dst, srcIIP, dstIIP);
        boolean added = false;
        try {
            if (!tx.removeSrc4OldRename()) {
                boolean bl = false;
                return bl;
            }
            added = tx.addSourceToDestination();
            if (added) {
                if (NameNode.stateChangeLog.isDebugEnabled()) {
                    NameNode.stateChangeLog.debug("DIR* FSDirectory.unprotectedRenameTo: " + src + " is renamed to " + dst);
                }
                tx.updateMtimeAndLease(timestamp);
                tx.updateQuotasInSourceTree(fsd.getBlockStoragePolicySuite());
                boolean bl = true;
                return bl;
            }
        }
        finally {
            if (!added) {
                tx.restoreSource();
            }
        }
        NameNode.stateChangeLog.warn("DIR* FSDirectory.unprotectedRenameTo: failed to rename " + src + " to " + dst);
        return false;
    }

    static Map.Entry<INode.BlocksMapUpdateInfo, HdfsFileStatus> renameToInt(FSDirectory fsd, String srcArg, String dstArg, boolean logRetryCache, Options.Rename ... options) throws IOException {
        String src = srcArg;
        String dst = dstArg;
        if (NameNode.stateChangeLog.isDebugEnabled()) {
            NameNode.stateChangeLog.debug("DIR* NameSystem.renameTo: with options - " + src + " to " + dst);
        }
        if (!DFSUtil.isValidName(dst)) {
            throw new InvalidPathException("Invalid name: " + dst);
        }
        FSPermissionChecker pc = fsd.getPermissionChecker();
        byte[][] srcComponents = FSDirectory.getPathComponentsForReservedPath(src);
        byte[][] dstComponents = FSDirectory.getPathComponentsForReservedPath(dst);
        INode.BlocksMapUpdateInfo collectedBlocks = new INode.BlocksMapUpdateInfo();
        src = fsd.resolvePath(pc, src, srcComponents);
        dst = fsd.resolvePath(pc, dst, dstComponents);
        FSDirRenameOp.renameTo(fsd, pc, src, dst, collectedBlocks, logRetryCache, options);
        INodesInPath dstIIP = fsd.getINodesInPath(dst, false);
        HdfsFileStatus resultingStat = fsd.getAuditFileInfo(dstIIP);
        return new AbstractMap.SimpleImmutableEntry<INode.BlocksMapUpdateInfo, HdfsFileStatus>(collectedBlocks, resultingStat);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void renameTo(FSDirectory fsd, FSPermissionChecker pc, String src, String dst, INode.BlocksMapUpdateInfo collectedBlocks, boolean logRetryCache, Options.Rename ... options) throws IOException {
        INodesInPath srcIIP = fsd.getINodesInPath4Write(src, false);
        INodesInPath dstIIP = fsd.getINodesInPath4Write(dst, false);
        if (fsd.isPermissionEnabled()) {
            fsd.checkPermission(pc, srcIIP, false, null, FsAction.WRITE, null, null, false);
            fsd.checkPermission(pc, dstIIP, false, FsAction.WRITE, null, null, null, false);
        }
        if (NameNode.stateChangeLog.isDebugEnabled()) {
            NameNode.stateChangeLog.debug("DIR* FSDirectory.renameTo: " + src + " to " + dst);
        }
        long mtime = Time.now();
        fsd.writeLock();
        try {
            if (FSDirRenameOp.unprotectedRenameTo(fsd, src, dst, srcIIP, dstIIP, mtime, collectedBlocks, options)) {
                FSDirDeleteOp.incrDeletedFileCount(1L);
            }
        }
        finally {
            fsd.writeUnlock();
        }
        fsd.getEditLog().logRename(src, dst, mtime, logRetryCache, options);
    }

    static boolean renameForEditLog(FSDirectory fsd, String src, String dst, long timestamp, Options.Rename ... options) throws IOException {
        INode.BlocksMapUpdateInfo collectedBlocks = new INode.BlocksMapUpdateInfo();
        INodesInPath srcIIP = fsd.getINodesInPath4Write(src, false);
        INodesInPath dstIIP = fsd.getINodesInPath4Write(dst, false);
        boolean ret = FSDirRenameOp.unprotectedRenameTo(fsd, src, dst, srcIIP, dstIIP, timestamp, collectedBlocks, options);
        if (!collectedBlocks.getToDeleteList().isEmpty()) {
            fsd.getFSNamesystem().removeBlocksAndUpdateSafemodeTotal(collectedBlocks);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean unprotectedRenameTo(FSDirectory fsd, String src, String dst, INodesInPath srcIIP, INodesInPath dstIIP, long timestamp, INode.BlocksMapUpdateInfo collectedBlocks, Options.Rename ... options) throws IOException {
        INode dstParent;
        assert (fsd.hasWriteLock());
        boolean overwrite = options != null && Arrays.asList(options).contains((Object)Options.Rename.OVERWRITE);
        INode srcInode = srcIIP.getLastINode();
        FSDirRenameOp.validateRenameSource(srcIIP);
        if (dst.equals(src)) {
            throw new FileAlreadyExistsException("The source " + src + " and destination " + dst + " are the same");
        }
        FSDirRenameOp.validateDestination(src, dst, srcInode);
        if (dstIIP.length() == 1) {
            String error = "rename destination cannot be the root";
            NameNode.stateChangeLog.warn("DIR* FSDirectory.unprotectedRenameTo: " + error);
            throw new IOException(error);
        }
        BlockStoragePolicySuite bsps = fsd.getBlockStoragePolicySuite();
        fsd.ezManager.checkMoveValidity(srcIIP, dstIIP, src);
        INode dstInode = dstIIP.getLastINode();
        ArrayList<INodeDirectory> snapshottableDirs = new ArrayList<INodeDirectory>();
        if (dstInode != null) {
            FSDirRenameOp.validateOverwrite(src, dst, overwrite, srcInode, dstInode);
            FSDirSnapshotOp.checkSnapshot(dstInode, snapshottableDirs);
        }
        if ((dstParent = dstIIP.getINode(-2)) == null) {
            String error = "rename destination parent " + dst + " not found.";
            NameNode.stateChangeLog.warn("DIR* FSDirectory.unprotectedRenameTo: " + error);
            throw new FileNotFoundException(error);
        }
        if (!dstParent.isDirectory()) {
            String error = "rename destination parent " + dst + " is a file.";
            NameNode.stateChangeLog.warn("DIR* FSDirectory.unprotectedRenameTo: " + error);
            throw new ParentNotDirectoryException(error);
        }
        FSDirRenameOp.verifyFsLimitsForRename(fsd, srcIIP, dstIIP);
        FSDirRenameOp.verifyQuotaForRename(fsd, srcIIP, dstIIP);
        RenameOperation tx = new RenameOperation(fsd, src, dst, srcIIP, dstIIP);
        boolean undoRemoveSrc = true;
        tx.removeSrc();
        boolean undoRemoveDst = false;
        long removedNum = 0L;
        try {
            if (dstInode != null && (removedNum = tx.removeDst()) != -1L) {
                undoRemoveDst = true;
            }
            if (tx.addSourceToDestination()) {
                undoRemoveSrc = false;
                if (NameNode.stateChangeLog.isDebugEnabled()) {
                    NameNode.stateChangeLog.debug("DIR* FSDirectory.unprotectedRenameTo: " + src + " is renamed to " + dst);
                }
                tx.updateMtimeAndLease(timestamp);
                boolean filesDeleted = false;
                if (undoRemoveDst) {
                    undoRemoveDst = false;
                    if (removedNum > 0L) {
                        filesDeleted = tx.cleanDst(bsps, collectedBlocks);
                    }
                }
                if (snapshottableDirs.size() > 0) {
                    fsd.getFSNamesystem().removeSnapshottableDirs(snapshottableDirs);
                }
                tx.updateQuotasInSourceTree(bsps);
                boolean bl = filesDeleted;
                return bl;
            }
        }
        finally {
            if (undoRemoveSrc) {
                tx.restoreSource();
            }
            if (undoRemoveDst) {
                tx.restoreDst(bsps);
            }
        }
        NameNode.stateChangeLog.warn("DIR* FSDirectory.unprotectedRenameTo: failed to rename " + src + " to " + dst);
        throw new IOException("rename from " + src + " to " + dst + " failed.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    private static boolean renameTo(FSDirectory fsd, FSPermissionChecker pc, String src, String dst, boolean logRetryCache) throws IOException {
        INodesInPath srcIIP = fsd.getINodesInPath4Write(src, false);
        String actualDst = fsd.isDir(dst) ? dst + "/" + new Path(src).getName() : dst;
        INodesInPath dstIIP = fsd.getINodesInPath4Write(actualDst, false);
        if (fsd.isPermissionEnabled()) {
            fsd.checkPermission(pc, srcIIP, false, null, FsAction.WRITE, null, null, false);
            fsd.checkPermission(pc, dstIIP, false, FsAction.WRITE, null, null, null, false);
        }
        if (NameNode.stateChangeLog.isDebugEnabled()) {
            NameNode.stateChangeLog.debug("DIR* FSDirectory.renameTo: " + src + " to " + dst);
        }
        long mtime = Time.now();
        boolean stat = false;
        fsd.writeLock();
        try {
            stat = FSDirRenameOp.unprotectedRenameTo(fsd, src, actualDst, srcIIP, dstIIP, mtime);
        }
        finally {
            fsd.writeUnlock();
        }
        if (stat) {
            fsd.getEditLog().logRename(src, actualDst, mtime, logRetryCache);
            return true;
        }
        return false;
    }

    private static void validateDestination(String src, String dst, INode srcInode) throws IOException {
        if (srcInode.isSymlink() && dst.equals(srcInode.asSymlink().getSymlinkString())) {
            throw new FileAlreadyExistsException("Cannot rename symlink " + src + " to its target " + dst);
        }
        if (dst.startsWith(src) && dst.charAt(src.length()) == '/') {
            String error = "Rename destination " + dst + " is a directory or file under source " + src;
            NameNode.stateChangeLog.warn("DIR* FSDirectory.unprotectedRenameTo: " + error);
            throw new IOException(error);
        }
    }

    private static void validateOverwrite(String src, String dst, boolean overwrite, INode srcInode, INode dstInode) throws IOException {
        ReadOnlyList<INode> children;
        if (dstInode.isDirectory() != srcInode.isDirectory()) {
            String error = "Source " + src + " and destination " + dst + " must both be directories";
            NameNode.stateChangeLog.warn("DIR* FSDirectory.unprotectedRenameTo: " + error);
            throw new IOException(error);
        }
        if (!overwrite) {
            String error = "rename destination " + dst + " already exists";
            NameNode.stateChangeLog.warn("DIR* FSDirectory.unprotectedRenameTo: " + error);
            throw new FileAlreadyExistsException(error);
        }
        if (dstInode.isDirectory() && !(children = dstInode.asDirectory().getChildrenList(0x7FFFFFFE)).isEmpty()) {
            String error = "rename destination directory is not empty: " + dst;
            NameNode.stateChangeLog.warn("DIR* FSDirectory.unprotectedRenameTo: " + error);
            throw new IOException(error);
        }
    }

    private static void validateRenameSource(INodesInPath srcIIP) throws IOException {
        INode srcInode = srcIIP.getLastINode();
        if (srcInode == null) {
            String error = "rename source " + srcIIP.getPath() + " is not found.";
            NameNode.stateChangeLog.warn("DIR* FSDirectory.unprotectedRenameTo: " + error);
            throw new FileNotFoundException(error);
        }
        if (srcIIP.length() == 1) {
            String error = "rename source cannot be the root";
            NameNode.stateChangeLog.warn("DIR* FSDirectory.unprotectedRenameTo: " + error);
            throw new IOException(error);
        }
        FSDirSnapshotOp.checkSnapshot(srcInode, null);
    }

    static class RenameOldResult {
        final boolean success;
        final HdfsFileStatus auditStat;

        RenameOldResult(boolean success, HdfsFileStatus auditStat) {
            this.success = success;
            this.auditStat = auditStat;
        }
    }

    private static class RenameOperation {
        private final FSDirectory fsd;
        private INodesInPath srcIIP;
        private final INodesInPath srcParentIIP;
        private INodesInPath dstIIP;
        private final INodesInPath dstParentIIP;
        private final String src;
        private final String dst;
        private final INodeReference.WithCount withCount;
        private final int srcRefDstSnapshot;
        private final INodeDirectory srcParent;
        private final byte[] srcChildName;
        private final boolean isSrcInSnapshot;
        private final boolean srcChildIsReference;
        private final QuotaCounts oldSrcCounts;
        private INode srcChild;
        private INode oldDstChild;

        RenameOperation(FSDirectory fsd, String src, String dst, INodesInPath srcIIP, INodesInPath dstIIP) throws QuotaExceededException {
            this.fsd = fsd;
            this.src = src;
            this.dst = dst;
            this.srcIIP = srcIIP;
            this.dstIIP = dstIIP;
            this.srcParentIIP = srcIIP.getParentINodesInPath();
            this.dstParentIIP = dstIIP.getParentINodesInPath();
            BlockStoragePolicySuite bsps = fsd.getBlockStoragePolicySuite();
            this.srcChild = this.srcIIP.getLastINode();
            this.srcChildName = this.srcChild.getLocalNameBytes();
            int srcLatestSnapshotId = srcIIP.getLatestSnapshotId();
            this.isSrcInSnapshot = this.srcChild.isInLatestSnapshot(srcLatestSnapshotId);
            this.srcChildIsReference = this.srcChild.isReference();
            this.srcParent = this.srcIIP.getINode(-2).asDirectory();
            if (this.isSrcInSnapshot) {
                this.srcChild.recordModification(srcLatestSnapshotId);
            }
            this.srcRefDstSnapshot = this.srcChildIsReference ? this.srcChild.asReference().getDstSnapshotId() : 0x7FFFFFFE;
            this.oldSrcCounts = new QuotaCounts.Builder().build();
            if (this.isSrcInSnapshot) {
                INodeReference.WithName withName = this.srcParent.replaceChild4ReferenceWithName(this.srcChild, srcLatestSnapshotId);
                this.withCount = (INodeReference.WithCount)withName.getReferredINode();
                this.srcChild = withName;
                this.srcIIP = INodesInPath.replace(srcIIP, srcIIP.length() - 1, this.srcChild);
                this.withCount.getReferredINode().computeQuotaUsage(bsps, this.oldSrcCounts, true);
            } else {
                this.withCount = this.srcChildIsReference ? (INodeReference.WithCount)this.srcChild.asReference().getReferredINode() : null;
            }
        }

        long removeSrc() throws IOException {
            long removedNum = this.fsd.removeLastINode(this.srcIIP);
            if (removedNum == -1L) {
                String error = "Failed to rename " + this.src + " to " + this.dst + " because the source can not be removed";
                NameNode.stateChangeLog.warn("DIR* FSDirRenameOp.unprotectedRenameTo:" + error);
                throw new IOException(error);
            }
            this.fsd.updateCountForDelete(this.srcChild, this.srcIIP);
            this.srcIIP = INodesInPath.replace(this.srcIIP, this.srcIIP.length() - 1, null);
            return removedNum;
        }

        boolean removeSrc4OldRename() {
            long removedSrc = this.fsd.removeLastINode(this.srcIIP);
            if (removedSrc == -1L) {
                NameNode.stateChangeLog.warn("DIR* FSDirRenameOp.unprotectedRenameTo: failed to rename " + this.src + " to " + this.dst + " because the source" + " can not be removed");
                return false;
            }
            this.fsd.updateCountForDelete(this.srcChild, this.srcIIP);
            this.srcIIP = INodesInPath.replace(this.srcIIP, this.srcIIP.length() - 1, null);
            return true;
        }

        long removeDst() {
            long removedNum = this.fsd.removeLastINode(this.dstIIP);
            if (removedNum != -1L) {
                this.oldDstChild = this.dstIIP.getLastINode();
                this.fsd.updateCountForDelete(this.oldDstChild, this.dstIIP);
                this.dstIIP = INodesInPath.replace(this.dstIIP, this.dstIIP.length() - 1, null);
            }
            return removedNum;
        }

        boolean addSourceToDestination() {
            INode toDst;
            INode dstParent = this.dstParentIIP.getLastINode();
            byte[] dstChildName = this.dstIIP.getLastLocalName();
            if (this.withCount == null) {
                this.srcChild.setLocalName(dstChildName);
                toDst = this.srcChild;
            } else {
                this.withCount.getReferredINode().setLocalName(dstChildName);
                toDst = new INodeReference.DstReference(dstParent.asDirectory(), this.withCount, this.dstIIP.getLatestSnapshotId());
            }
            return this.fsd.addLastINodeNoQuotaCheck(this.dstParentIIP, toDst) != null;
        }

        void updateMtimeAndLease(long timestamp) throws QuotaExceededException {
            this.srcParent.updateModificationTime(timestamp, this.srcIIP.getLatestSnapshotId());
            INode dstParent = this.dstParentIIP.getLastINode();
            dstParent.updateModificationTime(timestamp, this.dstIIP.getLatestSnapshotId());
            this.fsd.getFSNamesystem().unprotectedChangeLease(this.src, this.dst);
        }

        void restoreSource() throws QuotaExceededException {
            INode oldSrcChild = this.srcChild;
            if (this.withCount == null) {
                this.srcChild.setLocalName(this.srcChildName);
            } else if (!this.srcChildIsReference) {
                this.srcChild = this.withCount.getReferredINode();
                this.srcChild.setLocalName(this.srcChildName);
            } else {
                this.withCount.removeReference(oldSrcChild.asReference());
                this.srcChild = new INodeReference.DstReference(this.srcParent, this.withCount, this.srcRefDstSnapshot);
                this.withCount.getReferredINode().setLocalName(this.srcChildName);
            }
            if (this.isSrcInSnapshot) {
                this.srcParent.undoRename4ScrParent(oldSrcChild.asReference(), this.srcChild);
            } else {
                this.fsd.addLastINodeNoQuotaCheck(this.srcParentIIP, this.srcChild);
            }
        }

        void restoreDst(BlockStoragePolicySuite bsps) throws QuotaExceededException {
            Preconditions.checkState(this.oldDstChild != null);
            INodeDirectory dstParent = this.dstParentIIP.getLastINode().asDirectory();
            if (dstParent.isWithSnapshot()) {
                dstParent.undoRename4DstParent(bsps, this.oldDstChild, this.dstIIP.getLatestSnapshotId());
            } else {
                this.fsd.addLastINodeNoQuotaCheck(this.dstParentIIP, this.oldDstChild);
            }
            if (this.oldDstChild != null && this.oldDstChild.isReference()) {
                INodeReference removedDstRef = this.oldDstChild.asReference();
                INodeReference.WithCount wc = (INodeReference.WithCount)removedDstRef.getReferredINode().asReference();
                wc.addReference(removedDstRef);
            }
        }

        boolean cleanDst(BlockStoragePolicySuite bsps, INode.BlocksMapUpdateInfo collectedBlocks) throws QuotaExceededException {
            boolean filesDeleted;
            Preconditions.checkState(this.oldDstChild != null);
            ChunkedArrayList<INode> removedINodes = new ChunkedArrayList<INode>();
            if (!this.oldDstChild.isInLatestSnapshot(this.dstIIP.getLatestSnapshotId())) {
                this.oldDstChild.destroyAndCollectBlocks(bsps, collectedBlocks, removedINodes);
                filesDeleted = true;
            } else {
                filesDeleted = this.oldDstChild.cleanSubtree(bsps, 0x7FFFFFFE, this.dstIIP.getLatestSnapshotId(), collectedBlocks, removedINodes).getNameSpace() >= 0L;
            }
            this.fsd.getFSNamesystem().removeLeasesAndINodes(this.src, removedINodes, false);
            return filesDeleted;
        }

        void updateQuotasInSourceTree(BlockStoragePolicySuite bsps) throws QuotaExceededException {
            if (this.isSrcInSnapshot) {
                QuotaCounts newSrcCounts = this.srcChild.computeQuotaUsage(bsps, new QuotaCounts.Builder().build(), false);
                newSrcCounts.subtract(this.oldSrcCounts);
                this.srcParent.addSpaceConsumed(newSrcCounts, false);
            }
        }
    }
}

