/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.client;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.security.PrivilegedAction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.ipc.YarnRPC;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class AHSProxy<T> {
    private static final Log LOG = LogFactory.getLog(AHSProxy.class);

    public static <T> T createAHSProxy(Configuration conf, Class<T> protocol, InetSocketAddress ahsAddress) throws IOException {
        LOG.info("Connecting to Application History server at " + ahsAddress);
        return AHSProxy.getProxy(conf, protocol, ahsAddress);
    }

    protected static <T> T getProxy(final Configuration conf, final Class<T> protocol, final InetSocketAddress rmAddress) throws IOException {
        return UserGroupInformation.getCurrentUser().doAs(new PrivilegedAction<T>(){

            @Override
            public T run() {
                return YarnRPC.create(conf).getProxy(protocol, rmAddress, conf);
            }
        });
    }
}

