/*
 * Decompiled with CFR 0.152.
 */
package org.apache.curator.framework.recipes.locks;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.io.Closeable;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.recipes.leader.LeaderLatch;
import org.apache.curator.framework.recipes.leader.LeaderLatchListener;
import org.apache.curator.utils.CloseableScheduledExecutorService;
import org.apache.curator.utils.ThreadUtils;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Reaper
implements Closeable {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final CuratorFramework client;
    private final CloseableScheduledExecutorService executor;
    private final int reapingThresholdMs;
    private final Map<String, PathHolder> activePaths = Maps.newConcurrentMap();
    private final AtomicReference<State> state = new AtomicReference<State>(State.LATENT);
    private final LeaderLatch leaderLatch;
    private final AtomicBoolean reapingIsActive = new AtomicBoolean(true);
    static final int DEFAULT_REAPING_THRESHOLD_MS = (int)TimeUnit.MILLISECONDS.convert(5L, TimeUnit.MINUTES);
    @VisibleForTesting
    static final int EMPTY_COUNT_THRESHOLD = 3;

    public Reaper(CuratorFramework client) {
        this(client, Reaper.newExecutorService(), DEFAULT_REAPING_THRESHOLD_MS, null);
    }

    public Reaper(CuratorFramework client, int reapingThresholdMs) {
        this(client, Reaper.newExecutorService(), reapingThresholdMs, null);
    }

    public Reaper(CuratorFramework client, ScheduledExecutorService executor, int reapingThresholdMs) {
        this(client, executor, reapingThresholdMs, null);
    }

    public Reaper(CuratorFramework client, ScheduledExecutorService executor, int reapingThresholdMs, String leaderPath) {
        this.client = client;
        this.executor = new CloseableScheduledExecutorService(executor);
        this.reapingThresholdMs = reapingThresholdMs / 3;
        LeaderLatch localLeaderLatch = null;
        if (leaderPath != null) {
            localLeaderLatch = this.makeLeaderLatch(client, leaderPath);
        }
        this.leaderLatch = localLeaderLatch;
    }

    public void addPath(String path) {
        this.addPath(path, Mode.REAP_INDEFINITELY);
    }

    public void addPath(String path, Mode mode) {
        PathHolder pathHolder = new PathHolder(path, mode, 0);
        this.activePaths.put(path, pathHolder);
        this.schedule(pathHolder, this.reapingThresholdMs);
    }

    public boolean removePath(String path) {
        return this.activePaths.remove(path) != null;
    }

    public void start() throws Exception {
        Preconditions.checkState(this.state.compareAndSet(State.LATENT, State.STARTED), "Cannot be started more than once");
        if (this.leaderLatch != null) {
            this.leaderLatch.start();
        }
    }

    @Override
    public void close() throws IOException {
        if (this.state.compareAndSet(State.STARTED, State.CLOSED)) {
            this.executor.close();
            if (this.leaderLatch != null) {
                this.leaderLatch.close();
            }
        }
    }

    @VisibleForTesting
    protected Future<?> schedule(PathHolder pathHolder, int reapingThresholdMs) {
        if (this.reapingIsActive.get()) {
            return this.executor.schedule(pathHolder, reapingThresholdMs, TimeUnit.MILLISECONDS);
        }
        return null;
    }

    @VisibleForTesting
    protected void reap(PathHolder holder) {
        int newEmptyCount;
        boolean addBack;
        block14: {
            if (!this.activePaths.containsKey(holder.path)) {
                return;
            }
            addBack = true;
            newEmptyCount = 0;
            try {
                Stat stat = (Stat)this.client.checkExists().forPath(holder.path);
                if (stat != null) {
                    if (stat.getNumChildren() != 0) break block14;
                    if (holder.emptyCount + 1 >= 3) {
                        try {
                            this.client.delete().forPath(holder.path);
                            this.log.info("Reaping path: " + holder.path);
                            if (holder.mode == Mode.REAP_UNTIL_DELETE || holder.mode == Mode.REAP_UNTIL_GONE) {
                                addBack = false;
                            }
                            break block14;
                        }
                        catch (KeeperException.NoNodeException ignore) {
                            if (holder.mode == Mode.REAP_UNTIL_GONE) {
                                addBack = false;
                            }
                            break block14;
                        }
                        catch (KeeperException.NotEmptyException ignore) {}
                        break block14;
                    }
                    newEmptyCount = holder.emptyCount + 1;
                    break block14;
                }
                if (holder.mode == Mode.REAP_UNTIL_GONE) {
                    addBack = false;
                }
            }
            catch (Exception e) {
                this.log.error("Trying to reap: " + holder.path, e);
            }
        }
        if (!addBack) {
            this.activePaths.remove(holder.path);
        } else if (!Thread.currentThread().isInterrupted() && this.state.get() == State.STARTED && this.activePaths.containsKey(holder.path)) {
            this.activePaths.put(holder.path, holder);
            this.schedule(new PathHolder(holder.path, holder.mode, newEmptyCount), this.reapingThresholdMs);
        }
    }

    public static ScheduledExecutorService newExecutorService() {
        return ThreadUtils.newSingleThreadScheduledExecutor("Reaper");
    }

    private LeaderLatch makeLeaderLatch(CuratorFramework client, String leaderPath) {
        this.reapingIsActive.set(false);
        LeaderLatch localLeaderLatch = new LeaderLatch(client, leaderPath);
        LeaderLatchListener listener = new LeaderLatchListener(){

            @Override
            public void isLeader() {
                Reaper.this.reapingIsActive.set(true);
                for (PathHolder holder : Reaper.this.activePaths.values()) {
                    Reaper.this.schedule(holder, Reaper.this.reapingThresholdMs);
                }
            }

            @Override
            public void notLeader() {
                Reaper.this.reapingIsActive.set(false);
            }
        };
        localLeaderLatch.addListener(listener);
        return localLeaderLatch;
    }

    public static enum Mode {
        REAP_INDEFINITELY,
        REAP_UNTIL_DELETE,
        REAP_UNTIL_GONE;

    }

    @VisibleForTesting
    class PathHolder
    implements Runnable {
        final String path;
        final Mode mode;
        final int emptyCount;

        @Override
        public void run() {
            Reaper.this.reap(this);
        }

        private PathHolder(String path, Mode mode, int emptyCount) {
            this.path = path;
            this.mode = mode;
            this.emptyCount = emptyCount;
        }
    }

    private static enum State {
        LATENT,
        STARTED,
        CLOSED;

    }
}

