/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.tool;

import java.io.File;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.avro.Schema;
import org.apache.avro.mapred.tether.TetherJob;
import org.apache.avro.tool.Tool;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobConf;

public class TetherTool
implements Tool {
    public TetherJob job;

    @Override
    public String getName() {
        return "tether";
    }

    @Override
    public String getShortDescription() {
        return "Run a tethered mapreduce job.";
    }

    @Override
    public int run(InputStream ins, PrintStream outs, PrintStream err, List<String> args) throws Exception {
        String[] argarry = args.toArray(new String[0]);
        Options opts = new Options();
        OptionBuilder.hasArg((boolean)false);
        OptionBuilder.withDescription((String)"print this message");
        Option helpopt = OptionBuilder.create((String)"help");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired();
        OptionBuilder.withDescription((String)"comma-separated input paths");
        Option inopt = OptionBuilder.create((String)"in");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired();
        OptionBuilder.withDescription((String)"The output path.");
        Option outopt = OptionBuilder.create((String)"out");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"A string containing the command line arguments to pass to the tethered process. String should be enclosed in quotes");
        Option pargs = OptionBuilder.create((String)"exec_args");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired();
        OptionBuilder.withDescription((String)"executable program, usually in HDFS");
        Option popt = OptionBuilder.create((String)"program");
        OptionBuilder.withType(File.class);
        OptionBuilder.hasArg();
        OptionBuilder.isRequired();
        OptionBuilder.withDescription((String)"schema file for output of reducer");
        Option outscopt = OptionBuilder.create((String)"outschema");
        OptionBuilder.withType(File.class);
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"(optional) map output schema file,  if different from outschema");
        Option outscmapopt = OptionBuilder.create((String)"outschemamap");
        OptionBuilder.withType(Integer.class);
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"(optional) number of reducers");
        Option redopt = OptionBuilder.create((String)"reduces");
        OptionBuilder.withType(Boolean.class);
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"(optional) boolean indicating whether or not the exectuable should be distributed via distributed cache");
        Option cacheopt = OptionBuilder.create((String)"exec_cached");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"(optional) specifies the transport protocol 'http' or 'sasl'");
        Option protoopt = OptionBuilder.create((String)"protocol");
        opts.addOption(redopt);
        opts.addOption(outscopt);
        opts.addOption(popt);
        opts.addOption(pargs);
        opts.addOption(inopt);
        opts.addOption(outopt);
        opts.addOption(helpopt);
        opts.addOption(outscmapopt);
        opts.addOption(cacheopt);
        opts.addOption(protoopt);
        GnuParser parser = new GnuParser();
        String[] genargs = null;
        CommandLine line = null;
        HelpFormatter formatter = new HelpFormatter();
        JobConf job = new JobConf();
        try {
            line = parser.parse(opts, argarry);
            if (line.hasOption("help")) {
                formatter.printHelp("tether", opts);
                return 0;
            }
            genargs = line.getArgs();
            FileInputFormat.addInputPaths((JobConf)job, (String)line.getOptionValue("in"));
            FileOutputFormat.setOutputPath((JobConf)job, (Path)new Path(line.getOptionValue("out")));
            ArrayList<String> exargs = null;
            Boolean cached = false;
            if (line.hasOption("exec_args")) {
                String[] splitargs = line.getOptionValue("exec_args").split(" ");
                exargs = new ArrayList<String>(Arrays.asList(splitargs));
            }
            if (line.hasOption("exec_cached")) {
                cached = Boolean.parseBoolean(line.getOptionValue("exec_cached"));
            }
            TetherJob.setExecutable((JobConf)job, (File)new File(line.getOptionValue("program")), exargs, (boolean)cached);
            File outschema = (File)line.getParsedOptionValue("outschema");
            job.set("avro.output.schema", Schema.parse((File)outschema).toString());
            if (line.hasOption("outschemamap")) {
                job.set("avro.map.output.schema", new Schema.Parser().parse((File)line.getParsedOptionValue("outschemamap")).toString());
            }
            if (line.hasOption("reduces")) {
                job.setNumReduceTasks(((Integer)line.getParsedOptionValue("reduces")).intValue());
            }
            if (line.hasOption("protocol")) {
                TetherJob.setProtocol((JobConf)job, (String)line.getOptionValue("protocol"));
            }
        }
        catch (Exception exp) {
            System.out.println("Unexpected exception: " + exp.getMessage());
            formatter.printHelp("tether", opts);
            return -1;
        }
        TetherJob.runJob((JobConf)job);
        return 0;
    }
}

