/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.memory;

import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.memory.DefaultMemoryManagerFactory;
import org.glassfish.grizzly.memory.HeapMemoryManager;
import org.glassfish.grizzly.memory.MemoryManager;
import org.slf4j.Logger;

class MemoryManagerInitializer {
    private static final String DMM_PROP_NAME = "org.glassfish.grizzly.DEFAULT_MEMORY_MANAGER";
    private static final Logger LOGGER = Grizzly.logger(MemoryManagerInitializer.class);

    MemoryManagerInitializer() {
    }

    static MemoryManager initManager() {
        MemoryManager mm = MemoryManagerInitializer.initMemoryManagerViaFactory();
        return mm != null ? mm : MemoryManagerInitializer.initMemoryManagerFallback();
    }

    private static MemoryManager initMemoryManagerViaFactory() {
        DefaultMemoryManagerFactory mmf;
        String dmmfClassName = System.getProperty("org.glassfish.grizzly.MEMORY_MANAGER_FACTORY");
        if (dmmfClassName != null && (mmf = (DefaultMemoryManagerFactory)MemoryManagerInitializer.newInstance(dmmfClassName)) != null) {
            return mmf.createMemoryManager();
        }
        return null;
    }

    private static MemoryManager initMemoryManagerFallback() {
        String className = System.getProperty(DMM_PROP_NAME);
        MemoryManager mm = (MemoryManager)MemoryManagerInitializer.newInstance(className);
        return mm != null ? mm : new HeapMemoryManager();
    }

    private static <T> T newInstance(String className) {
        if (className == null) {
            return null;
        }
        try {
            Class<?> clazz = Class.forName(className, true, MemoryManager.class.getClassLoader());
            return (T)clazz.newInstance();
        }
        catch (Exception e) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error("Unable to load or create a new instance of Class {}.  Cause: {}", (Object)className, (Object)e.getMessage());
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(e.toString(), (Throwable)e);
            }
            return null;
        }
    }
}

