/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.samples.comet;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.http.HttpServletResponse;
import org.glassfish.grizzly.comet.CometEvent;
import org.glassfish.grizzly.comet.CometHandler;
import org.glassfish.grizzly.comet.DefaultCometHandler;

public class CounterHandler
extends DefaultCometHandler<HttpServletResponse> {
    private final HttpServletResponse httpResponse;
    private final AtomicInteger counter;

    CounterHandler(HttpServletResponse httpResponse, AtomicInteger counter) {
        this.httpResponse = httpResponse;
        this.counter = counter;
    }

    public void onEvent(CometEvent event) throws IOException {
        if (CometEvent.Type.NOTIFY == event.getType()) {
            this.httpResponse.addHeader("X-JSON", "{\"counter\":" + this.counter.get() + " }");
            PrintWriter writer = this.httpResponse.getWriter();
            writer.write("success");
            writer.flush();
            event.getCometContext().resumeCometHandler((CometHandler)this);
        }
    }

    public void onInterrupt(CometEvent event) throws IOException {
        this.httpResponse.addHeader("X-JSON", "{\"counter\":" + this.counter.get() + " }");
        PrintWriter writer = this.httpResponse.getWriter();
        writer.write("success");
        writer.flush();
    }
}

