/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.samples.lifecycle;

import java.io.IOException;
import org.glassfish.grizzly.Processor;
import org.glassfish.grizzly.filterchain.Filter;
import org.glassfish.grizzly.filterchain.FilterChainBuilder;
import org.glassfish.grizzly.filterchain.TransportFilter;
import org.glassfish.grizzly.nio.transport.TCPNIOTransport;
import org.glassfish.grizzly.nio.transport.TCPNIOTransportBuilder;
import org.glassfish.grizzly.samples.echo.EchoFilter;
import org.glassfish.grizzly.samples.lifecycle.LifeCycleFilter;

public class LifeCycleExample {
    public static final String HOST = "localhost";
    public static final int PORT = 7777;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException {
        LifeCycleFilter lifeCycleFilter = new LifeCycleFilter();
        FilterChainBuilder filterChainBuilder = FilterChainBuilder.stateless();
        filterChainBuilder.add((Filter)new TransportFilter());
        filterChainBuilder.add((Filter)lifeCycleFilter);
        filterChainBuilder.add((Filter)new EchoFilter());
        TCPNIOTransport transport = TCPNIOTransportBuilder.newInstance().build();
        transport.setProcessor((Processor)filterChainBuilder.build());
        try {
            transport.bind(HOST, 7777);
            transport.start();
            System.out.println("Press 'q and ENTER' to exit, or just ENTER to see statistics...");
            do {
                LifeCycleExample.printStats(lifeCycleFilter);
            } while (System.in.read() != 113);
        }
        finally {
            transport.shutdownNow();
        }
    }

    private static void printStats(LifeCycleFilter lifeCycleFilter) {
        System.out.println("The total number of connections ever connected: " + lifeCycleFilter.getTotalConnections());
        System.out.println("The number of active connections: " + lifeCycleFilter.getActiveConnections().size());
    }
}

