/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.samples.simpleauth;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.GrizzlyFuture;
import org.glassfish.grizzly.Processor;
import org.glassfish.grizzly.filterchain.Filter;
import org.glassfish.grizzly.filterchain.FilterChainBuilder;
import org.glassfish.grizzly.filterchain.TransportFilter;
import org.glassfish.grizzly.nio.transport.TCPNIOTransport;
import org.glassfish.grizzly.nio.transport.TCPNIOTransportBuilder;
import org.glassfish.grizzly.samples.simpleauth.ClientAuthFilter;
import org.glassfish.grizzly.samples.simpleauth.ClientFilter;
import org.glassfish.grizzly.samples.simpleauth.MultiLineFilter;
import org.glassfish.grizzly.samples.simpleauth.MultiLinePacket;
import org.glassfish.grizzly.samples.simpleauth.MultiStringFilter;
import org.glassfish.grizzly.utils.Charsets;

public class Client {
    private static final Logger logger = Logger.getLogger(Client.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        FilterChainBuilder filterChainBuilder = FilterChainBuilder.stateless();
        filterChainBuilder.add((Filter)new TransportFilter());
        filterChainBuilder.add((Filter)new MultiStringFilter(Charset.forName("ASCII"), "\n"){

            @Override
            protected List<String> createInList() {
                return new LinkedList<String>();
            }
        });
        filterChainBuilder.add((Filter)new MultiLineFilter(""));
        filterChainBuilder.add((Filter)new ClientAuthFilter());
        filterChainBuilder.add((Filter)new ClientFilter());
        TCPNIOTransport transport = TCPNIOTransportBuilder.newInstance().build();
        transport.setProcessor((Processor)filterChainBuilder.build());
        try {
            transport.start();
            GrizzlyFuture connectFuture = transport.connect("localhost", 7777);
            Connection connection = (Connection)connectFuture.get(10L, TimeUnit.SECONDS);
            BufferedReader reader = new BufferedReader(new InputStreamReader(System.in, Charsets.ASCII_CHARSET));
            while (true) {
                System.out.print("Type the message (Empty line for quit): ");
                String input = reader.readLine();
                if ("".equals(input)) {
                    break;
                }
                MultiLinePacket request = MultiLinePacket.create("echo", input);
                logger.log(Level.INFO, "--------- Client is sending the request:\n{0}", request);
                connection.write((Object)request);
            }
        }
        finally {
            logger.info("Stopping transport...");
            transport.shutdownNow();
            logger.info("Stopped transport...");
        }
    }
}

