/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.samples.simpleauth;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.attributes.Attribute;
import org.glassfish.grizzly.attributes.AttributeStorage;
import org.glassfish.grizzly.filterchain.BaseFilter;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.filterchain.NextAction;
import org.glassfish.grizzly.samples.simpleauth.MultiLinePacket;
import org.slf4j.Logger;

public class MultiLineFilter
extends BaseFilter {
    private static final Logger LOGGER = Grizzly.logger(MultiLineFilter.class);
    private final String terminatingLine;
    private static final Attribute<MultiLinePacket> incompletePacketAttr = Grizzly.DEFAULT_ATTRIBUTE_BUILDER.createAttribute("Multiline-decoder-packet");

    public MultiLineFilter(String terminatingLine) {
        this.terminatingLine = terminatingLine;
    }

    public NextAction handleRead(FilterChainContext ctx) throws IOException {
        Connection connection = ctx.getConnection();
        List input = (List)ctx.getMessage();
        MultiLinePacket packet = (MultiLinePacket)incompletePacketAttr.remove((AttributeStorage)connection);
        if (packet == null) {
            packet = MultiLinePacket.create();
        }
        boolean foundTerm = false;
        Iterator it = input.iterator();
        while (it.hasNext()) {
            String line = (String)it.next();
            it.remove();
            if (line.equals(this.terminatingLine)) {
                foundTerm = true;
                break;
            }
            packet.getLines().add(line);
        }
        if (!foundTerm) {
            incompletePacketAttr.set((AttributeStorage)connection, (Object)packet);
            return ctx.getStopAction();
        }
        ctx.setMessage((Object)packet);
        LOGGER.info("-------- Received from network:\n{}", (Object)packet);
        return input.isEmpty() ? ctx.getInvokeAction() : ctx.getInvokeAction((Object)input);
    }

    public NextAction handleWrite(FilterChainContext ctx) throws IOException {
        MultiLinePacket input = (MultiLinePacket)ctx.getMessage();
        LOGGER.info("------- Sending to network:\n{}", (Object)input);
        ArrayList<String> stringList = new ArrayList<String>(input.getLines().size() + 1);
        stringList.addAll(input.getLines());
        stringList.add(this.terminatingLine);
        ctx.setMessage(stringList);
        return ctx.getInvokeAction();
    }
}

