/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.samples.udpecho;

import java.io.IOException;
import java.nio.charset.Charset;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.Processor;
import org.glassfish.grizzly.filterchain.BaseFilter;
import org.glassfish.grizzly.filterchain.Filter;
import org.glassfish.grizzly.filterchain.FilterChainBuilder;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.filterchain.NextAction;
import org.glassfish.grizzly.filterchain.TransportFilter;
import org.glassfish.grizzly.impl.FutureImpl;
import org.glassfish.grizzly.impl.SafeFutureImpl;
import org.glassfish.grizzly.nio.transport.UDPNIOTransport;
import org.glassfish.grizzly.nio.transport.UDPNIOTransportBuilder;
import org.glassfish.grizzly.utils.StringFilter;
import org.slf4j.Logger;

public class EchoClient {
    private static final Logger LOGGER = Grizzly.logger(EchoClient.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException, ExecutionException, InterruptedException, TimeoutException {
        SafeFutureImpl future = SafeFutureImpl.create();
        FilterChainBuilder filterChainBuilder = FilterChainBuilder.stateless();
        filterChainBuilder.add((Filter)new TransportFilter());
        filterChainBuilder.add((Filter)new StringFilter(Charset.forName("UTF-8")));
        filterChainBuilder.add((Filter)new ClientFilter("Echo test", (FutureImpl)future));
        UDPNIOTransport transport = UDPNIOTransportBuilder.newInstance().build();
        transport.setProcessor((Processor)filterChainBuilder.build());
        try {
            transport.start();
            transport.connect("localhost", 7777);
            boolean isEqual = (Boolean)future.get(10L, TimeUnit.SECONDS);
            assert (isEqual);
            LOGGER.info("Echo came successfully");
        }
        finally {
            transport.shutdownNow();
        }
    }

    static class ClientFilter
    extends BaseFilter {
        private final String message;
        private final FutureImpl<Boolean> future;

        private ClientFilter(String message, FutureImpl<Boolean> future) {
            this.message = message;
            this.future = future;
        }

        public NextAction handleConnect(FilterChainContext ctx) throws IOException {
            ctx.write((Object)this.message);
            return ctx.getInvokeAction();
        }

        public NextAction handleRead(FilterChainContext ctx) throws IOException {
            String messageFromServer = (String)ctx.getMessage();
            this.future.result((Object)this.message.equals(messageFromServer));
            return ctx.getInvokeAction();
        }
    }
}

