/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.samples.udpmulticast;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.charset.Charset;
import java.util.concurrent.TimeUnit;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.GrizzlyFuture;
import org.glassfish.grizzly.Processor;
import org.glassfish.grizzly.filterchain.Filter;
import org.glassfish.grizzly.filterchain.FilterChain;
import org.glassfish.grizzly.filterchain.FilterChainBuilder;
import org.glassfish.grizzly.filterchain.TransportFilter;
import org.glassfish.grizzly.nio.transport.UDPNIOConnection;
import org.glassfish.grizzly.nio.transport.UDPNIOTransport;
import org.glassfish.grizzly.nio.transport.UDPNIOTransportBuilder;
import org.glassfish.grizzly.samples.udpmulticast.ChatCommand;
import org.glassfish.grizzly.samples.udpmulticast.PrintFilter;
import org.glassfish.grizzly.utils.JdkVersion;
import org.glassfish.grizzly.utils.StringFilter;
import org.slf4j.Logger;

public class MulticastChat {
    private static final Logger LOGGER = Grizzly.logger(MulticastChat.class);
    private static final int PORT = 8888;

    public static void main(String[] args) throws Exception {
        new MulticastChat().run();
    }

    private void run() throws Exception {
        JdkVersion jdkVersion = JdkVersion.getJdkVersion();
        JdkVersion minimumVersion = JdkVersion.parseVersion((String)"1.7.0");
        if (minimumVersion.compareTo(jdkVersion) > 0) {
            System.out.println("Sample requires JDK 1.7+");
            System.exit(1);
        }
        FilterChain filterChain = FilterChainBuilder.stateless().add((Filter)new TransportFilter()).add((Filter)new StringFilter(Charset.forName("UTF-8"))).add((Filter)new PrintFilter()).build();
        UDPNIOTransport transport = ((UDPNIOTransportBuilder)UDPNIOTransportBuilder.newInstance().setProcessor((Processor)filterChain)).build();
        UDPNIOConnection connection = null;
        try {
            transport.start();
            GrizzlyFuture connectFuture = transport.connect(null, (SocketAddress)new InetSocketAddress(8888));
            connection = (UDPNIOConnection)connectFuture.get(10L, TimeUnit.SECONDS);
            BufferedReader reader = new BufferedReader(new InputStreamReader(System.in, Charset.forName("UTF-8")));
            MulticastChat.printCommands();
            while (true) {
                System.out.print("\n$");
                try {
                    ChatCommand command = ChatCommand.parse(reader.readLine());
                    if (command == null) {
                        MulticastChat.printCommands();
                    } else {
                        command.run(connection);
                        if (command.isExit()) {
                            return;
                        }
                    }
                }
                catch (Throwable t) {
                    System.out.println(t.getClass().getName() + ": " + t.getMessage());
                }
            }
        }
        finally {
            if (connection != null) {
                connection.close();
            }
            LOGGER.debug("Stopping transport...");
            transport.shutdownNow();
            LOGGER.debug("Stopped transport...");
        }
    }

    private static void printCommands() {
        System.out.println("Please make your choice (type command number and command parameters separated by space:");
        System.out.println("1: send message. Parameters: group_addr message. Example: '$1 228.5.6.7 hello'");
        System.out.println("2: join the group. Parameters: group_addr network_interface [source]. Example: '$2 228.5.6.7 eth0'");
        System.out.println("3: leave the group. Parameters: group_addr network_interface [source]. Example: '$3 228.5.6.7 eth0'");
        System.out.println("4: block the source. Parameters: group_addr network_interface source. Example: '$4 228.5.6.7 eth0 192.168.0.10'");
        System.out.println("5: unblock the source. Parameters: group_addr network_interface source. Example: '$5 228.5.6.7 eth0 192.168.0.10'");
        System.out.println("6: list network interfaces. No parameters");
        System.out.println("7: exit");
    }
}

