/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.samples.filterchain;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.GrizzlyFuture;
import org.glassfish.grizzly.Processor;
import org.glassfish.grizzly.filterchain.BaseFilter;
import org.glassfish.grizzly.filterchain.Filter;
import org.glassfish.grizzly.filterchain.FilterChainBuilder;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.filterchain.NextAction;
import org.glassfish.grizzly.filterchain.TransportFilter;
import org.glassfish.grizzly.impl.FutureImpl;
import org.glassfish.grizzly.impl.SafeFutureImpl;
import org.glassfish.grizzly.nio.transport.TCPNIOTransport;
import org.glassfish.grizzly.nio.transport.TCPNIOTransportBuilder;
import org.glassfish.grizzly.samples.filterchain.GIOPFilter;
import org.glassfish.grizzly.samples.filterchain.GIOPMessage;
import org.glassfish.grizzly.utils.Charsets;

public class GIOPClient {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        Connection connection = null;
        SafeFutureImpl resultMessageFuture = SafeFutureImpl.create();
        FilterChainBuilder filterChainBuilder = FilterChainBuilder.stateless();
        filterChainBuilder.add((Filter)new TransportFilter());
        filterChainBuilder.add((Filter)new GIOPFilter());
        filterChainBuilder.add((Filter)new CustomClientFilter((FutureImpl<GIOPMessage>)resultMessageFuture));
        TCPNIOTransport transport = TCPNIOTransportBuilder.newInstance().build();
        transport.setProcessor((Processor)filterChainBuilder.build());
        try {
            transport.start();
            GrizzlyFuture future = transport.connect("localhost", 9098);
            connection = (Connection)future.get(10L, TimeUnit.SECONDS);
            byte[] testMessage = "GIOP test".getBytes(Charsets.ASCII_CHARSET);
            GIOPMessage sentMessage = new GIOPMessage(1, 2, 15, 0, testMessage);
            connection.write((Object)sentMessage);
            GIOPMessage rcvMessage = (GIOPMessage)resultMessageFuture.get(10L, TimeUnit.SECONDS);
            if (sentMessage.equals(rcvMessage)) {
                System.out.println("DONE!");
            } else {
                System.out.println("Messages are not equal!");
            }
        }
        finally {
            if (connection != null) {
                connection.closeSilently();
            }
            transport.shutdownNow();
        }
    }

    public static final class CustomClientFilter
    extends BaseFilter {
        private final FutureImpl<GIOPMessage> resultFuture;

        public CustomClientFilter(FutureImpl<GIOPMessage> resultFuture) {
            this.resultFuture = resultFuture;
        }

        public NextAction handleRead(FilterChainContext ctx) throws IOException {
            GIOPMessage message = (GIOPMessage)ctx.getMessage();
            this.resultFuture.result((Object)message);
            return ctx.getStopAction();
        }
    }
}

