/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.samples.simpleauth;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class MultiLinePacket {
    private final List<String> lines;

    public static MultiLinePacket create() {
        return new MultiLinePacket();
    }

    public static MultiLinePacket create(String ... lines) {
        MultiLinePacket packet = new MultiLinePacket();
        packet.getLines().addAll(Arrays.asList(lines));
        return packet;
    }

    static MultiLinePacket create(List<String> lines) {
        return new MultiLinePacket(lines);
    }

    private MultiLinePacket() {
        this.lines = new ArrayList<String>();
    }

    private MultiLinePacket(List<String> lines) {
        this.lines = lines;
    }

    public List<String> getLines() {
        return this.lines;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(256);
        for (String line : this.lines) {
            sb.append(line).append("\n");
        }
        return sb.toString();
    }

    public boolean equals(Object obj) {
        return obj instanceof MultiLinePacket && this.lines.equals(((MultiLinePacket)obj).lines);
    }

    public int hashCode() {
        int hash = 7;
        hash = 89 * hash + (this.lines != null ? this.lines.hashCode() : 0);
        return hash;
    }
}

