/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.samples.httpmultipart;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Writer;
import java.util.concurrent.atomic.AtomicInteger;
import org.glassfish.grizzly.CompletionHandler;
import org.glassfish.grizzly.EmptyCompletionHandler;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.ReadHandler;
import org.glassfish.grizzly.http.io.NIOInputStream;
import org.glassfish.grizzly.http.multipart.ContentDisposition;
import org.glassfish.grizzly.http.multipart.MultipartEntry;
import org.glassfish.grizzly.http.multipart.MultipartEntryHandler;
import org.glassfish.grizzly.http.multipart.MultipartScanner;
import org.glassfish.grizzly.http.server.HttpHandler;
import org.glassfish.grizzly.http.server.Request;
import org.glassfish.grizzly.http.server.Response;
import org.slf4j.Logger;

public class UploaderHttpHandler
extends HttpHandler {
    private static final Logger LOGGER = Grizzly.logger(UploaderHttpHandler.class);
    private static final String DESCRIPTION_NAME = "description";
    private static final String FILENAME_ENTRY = "fileName";
    private final AtomicInteger uploadsCounter = new AtomicInteger(1);

    public void service(Request request, final Response response) throws Exception {
        response.suspend();
        final int uploadNumber = this.uploadsCounter.getAndIncrement();
        LOGGER.info("Starting upload #{}", (Object)uploadNumber);
        final UploaderMultipartHandler uploader = new UploaderMultipartHandler(uploadNumber);
        MultipartScanner.scan((Request)request, (MultipartEntryHandler)uploader, (CompletionHandler)new EmptyCompletionHandler<Request>(){

            public void completed(Request request) {
                int bytesUploaded = uploader.getBytesUploaded();
                LOGGER.info("Upload #{}: is complete. {} bytes uploaded", (Object)uploadNumber, (Object)bytesUploaded);
                try {
                    response.setContentType("text/plain");
                    Writer writer = response.getWriter();
                    writer.write("Completed. " + bytesUploaded + " bytes uploaded.");
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                response.resume();
            }

            public void failed(Throwable throwable) {
                LOGGER.info("Upload #{} failed", (Object)uploadNumber, (Object)throwable);
                response.resume();
            }
        });
    }

    private static final class UploaderMultipartHandler
    implements MultipartEntryHandler {
        private final int uploadNumber;
        private final AtomicInteger uploadedBytesCounter = new AtomicInteger();

        public UploaderMultipartHandler(int uploadNumber) {
            this.uploadNumber = uploadNumber;
        }

        public void handle(MultipartEntry multipartEntry) throws Exception {
            ContentDisposition contentDisposition = multipartEntry.getContentDisposition();
            String name = contentDisposition.getDispositionParamUnquoted("name");
            if (UploaderHttpHandler.FILENAME_ENTRY.equals(name)) {
                String filename = contentDisposition.getDispositionParamUnquoted("filename");
                NIOInputStream inputStream = multipartEntry.getNIOInputStream();
                LOGGER.info("Upload #{}: uploading file {}", (Object)this.uploadNumber, (Object)filename);
                inputStream.notifyAvailable((ReadHandler)new UploadReadHandler(this.uploadNumber, filename, inputStream, this.uploadedBytesCounter));
            } else if (UploaderHttpHandler.DESCRIPTION_NAME.equals(name)) {
                LOGGER.info("Upload #{}: description came. Skipping...", (Object)this.uploadNumber);
                multipartEntry.skip();
            } else {
                LOGGER.info("Upload #{}: unknown multipart entry. Skipping...", (Object)this.uploadNumber);
                multipartEntry.skip();
            }
        }

        int getBytesUploaded() {
            return this.uploadedBytesCounter.get();
        }
    }

    private static class UploadReadHandler
    implements ReadHandler {
        private final int uploadNumber;
        private final NIOInputStream inputStream;
        private final FileOutputStream fileOutputStream;
        private final byte[] buf;
        private final AtomicInteger uploadedBytesCounter;

        private UploadReadHandler(int uploadNumber, String filename, NIOInputStream inputStream, AtomicInteger uploadedBytesCounter) throws FileNotFoundException {
            this.uploadNumber = uploadNumber;
            this.fileOutputStream = new FileOutputStream(filename);
            this.inputStream = inputStream;
            this.uploadedBytesCounter = uploadedBytesCounter;
            this.buf = new byte[2048];
        }

        public void onDataAvailable() throws Exception {
            this.readAndSaveAvail();
            this.inputStream.notifyAvailable((ReadHandler)this);
        }

        public void onAllDataRead() throws Exception {
            this.readAndSaveAvail();
            this.finish();
        }

        public void onError(Throwable t) {
            LOGGER.warn("Upload #{}: failed", (Object)this.uploadNumber, (Object)t);
            this.finish();
        }

        private void readAndSaveAvail() throws IOException {
            while (this.inputStream.isReady()) {
                int readBytes = this.inputStream.read(this.buf);
                this.uploadedBytesCounter.addAndGet(readBytes);
                this.fileOutputStream.write(this.buf, 0, readBytes);
            }
        }

        private void finish() {
            try {
                this.fileOutputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

