/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.samples.http.download;

import java.io.CharConversionException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.CompletionHandler;
import org.glassfish.grizzly.EmptyCompletionHandler;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.WriteResult;
import org.glassfish.grizzly.filterchain.BaseFilter;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.filterchain.NextAction;
import org.glassfish.grizzly.http.HttpContent;
import org.glassfish.grizzly.http.HttpPacket;
import org.glassfish.grizzly.http.HttpRequestPacket;
import org.glassfish.grizzly.http.HttpResponsePacket;
import org.glassfish.grizzly.http.HttpTrailer;
import org.glassfish.grizzly.memory.Buffers;
import org.glassfish.grizzly.memory.MemoryManager;
import org.slf4j.Logger;

public class WebServerFilter
extends BaseFilter {
    private static final Logger LOGGER = Grizzly.logger(WebServerFilter.class);
    private final File rootFolderFile;

    public WebServerFilter(String rootFolder) {
        this.rootFolderFile = rootFolder != null ? new File(rootFolder) : new File(".");
        if (!this.rootFolderFile.isDirectory()) {
            throw new IllegalStateException("Directory " + rootFolder + " doesn't exist");
        }
    }

    public NextAction handleRead(FilterChainContext ctx) throws IOException {
        HttpContent httpContent = (HttpContent)ctx.getMessage();
        HttpRequestPacket request = (HttpRequestPacket)httpContent.getHttpHeader();
        if (!httpContent.isLast()) {
            return ctx.getStopAction();
        }
        String localURL = WebServerFilter.extractLocalURL(request);
        File file = new File(this.rootFolderFile, localURL);
        LOGGER.info("Request file: {}", (Object)file.getAbsolutePath());
        if (!file.isFile()) {
            HttpPacket response = WebServerFilter.create404(request);
            ctx.write((Object)response);
            return ctx.getStopAction();
        }
        ctx.suspend();
        NextAction suspendAction = ctx.getSuspendAction();
        this.downloadFile(ctx, request, file);
        return suspendAction;
    }

    private void downloadFile(FilterChainContext ctx, HttpRequestPacket request, File file) throws IOException {
        DownloadCompletionHandler downloadHandler = new DownloadCompletionHandler(ctx, request, file);
        downloadHandler.start();
    }

    private static HttpPacket create404(HttpRequestPacket request) throws CharConversionException {
        HttpResponsePacket responseHeader = ((HttpResponsePacket.Builder)HttpResponsePacket.builder((HttpRequestPacket)request).protocol(request.getProtocol())).status(404).reasonPhrase("Not Found").build();
        return responseHeader.httpContentBuilder().content(Buffers.wrap(null, (String)("Can not find file, corresponding to URI: " + request.getRequestURIRef().getDecodedURI()))).build();
    }

    private static String extractLocalURL(HttpRequestPacket request) throws CharConversionException {
        String url = request.getRequestURIRef().getDecodedURI();
        int idx = url.indexOf("://");
        if (idx != -1) {
            int localPartStart = url.indexOf(47, idx + 3);
            url = localPartStart != -1 ? url.substring(localPartStart + 1) : "/";
        }
        return url;
    }

    private static class DownloadCompletionHandler
    extends EmptyCompletionHandler<WriteResult> {
        private final MemoryManager memoryManager;
        private final InputStream in;
        private final FilterChainContext ctx;
        private final HttpResponsePacket response;
        private volatile boolean isDone;

        public DownloadCompletionHandler(FilterChainContext ctx, HttpRequestPacket request, File file) throws FileNotFoundException {
            this.in = new FileInputStream(file);
            this.ctx = ctx;
            this.response = ((HttpResponsePacket.Builder)((HttpResponsePacket.Builder)HttpResponsePacket.builder((HttpRequestPacket)request).protocol(request.getProtocol())).status(200).reasonPhrase("OK").chunked(true)).build();
            this.memoryManager = ctx.getMemoryManager();
        }

        public void start() throws IOException {
            this.sendFileChunk();
        }

        public void sendFileChunk() throws IOException {
            HttpTrailer content;
            int length;
            int offset;
            Buffer buffer = this.memoryManager.allocate(1024);
            byte[] bufferByteArray = buffer.array();
            int bytesRead = this.in.read(bufferByteArray, offset = buffer.arrayOffset(), length = buffer.remaining());
            if (bytesRead == -1) {
                content = this.response.httpTrailerBuilder().build();
                this.isDone = true;
            } else {
                buffer.limit(bytesRead);
                content = this.response.httpContentBuilder().content(buffer).build();
            }
            this.ctx.write((Object)content, (CompletionHandler)this);
        }

        public void completed(WriteResult result) {
            try {
                if (!this.isDone) {
                    this.sendFileChunk();
                } else {
                    this.close();
                    this.resume();
                }
            }
            catch (IOException e) {
                this.failed(e);
            }
        }

        public void cancelled() {
            this.close();
            this.resume();
        }

        public void failed(Throwable throwable) {
            this.close();
            this.resume();
        }

        public boolean isDone() {
            return this.isDone;
        }

        private void close() {
            try {
                this.in.close();
            }
            catch (IOException e) {
                LOGGER.debug("Error closing a downloading file");
            }
        }

        private void resume() {
            this.ctx.resume(this.ctx.getStopAction());
        }
    }
}

