/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.samples.httpserver.priorities;

import java.io.IOException;
import java.util.concurrent.ExecutorService;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.http.server.HttpHandler;
import org.glassfish.grizzly.http.server.HttpServer;
import org.glassfish.grizzly.http.server.NetworkListener;
import org.glassfish.grizzly.http.server.ServerConfiguration;
import org.glassfish.grizzly.memory.MemoryManager;
import org.glassfish.grizzly.samples.httpserver.priorities.HighPriorityHandler;
import org.glassfish.grizzly.samples.httpserver.priorities.LowPriorityHandler;
import org.glassfish.grizzly.threadpool.GrizzlyExecutorService;
import org.glassfish.grizzly.threadpool.ThreadPoolConfig;
import org.slf4j.Logger;

public class Server {
    private static final Logger LOGGER = Grizzly.logger(Server.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        ThreadPoolConfig lowPriorityThreadPoolConfig = ThreadPoolConfig.defaultConfig().copy().setPoolName("low-priority-thread-pool").setCorePoolSize(2).setMaxPoolSize(16).setMemoryManager(MemoryManager.DEFAULT_MEMORY_MANAGER).setPriority(1);
        ThreadPoolConfig highPriorityThreadPoolConfig = ThreadPoolConfig.defaultConfig().copy().setPoolName("high-priority-thread-pool").setCorePoolSize(2).setMaxPoolSize(16).setMemoryManager(MemoryManager.DEFAULT_MEMORY_MANAGER).setPriority(10);
        GrizzlyExecutorService lowPriorityExecutorService = GrizzlyExecutorService.createInstance((ThreadPoolConfig)lowPriorityThreadPoolConfig);
        GrizzlyExecutorService highPriorityExecutorService = GrizzlyExecutorService.createInstance((ThreadPoolConfig)highPriorityThreadPoolConfig);
        HttpServer server = new HttpServer();
        ServerConfiguration config = server.getServerConfiguration();
        config.addHttpHandler((HttpHandler)new LowPriorityHandler((ExecutorService)lowPriorityExecutorService), new String[]{"/doNormal"});
        config.addHttpHandler((HttpHandler)new HighPriorityHandler((ExecutorService)highPriorityExecutorService), new String[]{"/doService"});
        NetworkListener networkListener = new NetworkListener("prioritization-test", "0.0.0.0", 8080);
        networkListener.getTransport().setWorkerThreadPoolConfig(null);
        server.addListener(networkListener);
        try {
            server.start();
            System.out.println("The server is running. Press enter to stop...");
            System.in.read();
        }
        catch (IOException ioe) {
            LOGGER.error(ioe.toString(), (Throwable)ioe);
        }
        finally {
            server.shutdownNow();
            lowPriorityExecutorService.shutdownNow();
            highPriorityExecutorService.shutdownNow();
        }
    }
}

