/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.samples.httpserver.secure;

import java.io.IOException;
import java.net.URL;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.http.server.HttpHandler;
import org.glassfish.grizzly.http.server.HttpServer;
import org.glassfish.grizzly.http.server.NetworkListener;
import org.glassfish.grizzly.http.server.ServerConfiguration;
import org.glassfish.grizzly.samples.httpserver.secure.SimpleHttpHandler;
import org.glassfish.grizzly.ssl.SSLContextConfigurator;
import org.glassfish.grizzly.ssl.SSLEngineConfigurator;
import org.slf4j.Logger;

public class Server {
    private static final Logger LOGGER = Grizzly.logger(Server.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        HttpServer server = new HttpServer();
        ServerConfiguration config = server.getServerConfiguration();
        config.addHttpHandler((HttpHandler)new SimpleHttpHandler(), new String[]{"/"});
        NetworkListener networkListener = new NetworkListener("secured-listener", "0.0.0.0", 8080);
        networkListener.setSecure(true);
        networkListener.setSSLEngineConfig(Server.createSslConfiguration());
        server.addListener(networkListener);
        try {
            server.start();
            System.out.println("The secured server is running.\nhttps://localhost:8080\nPress enter to stop...");
            System.in.read();
        }
        catch (IOException ioe) {
            LOGGER.error(ioe.toString(), (Throwable)ioe);
        }
        finally {
            server.shutdownNow();
        }
    }

    private static SSLEngineConfigurator createSslConfiguration() {
        SSLContextConfigurator sslContextConfig = new SSLContextConfigurator();
        ClassLoader cl = Server.class.getClassLoader();
        URL keystoreUrl = cl.getResource("ssltest-keystore.jks");
        if (keystoreUrl != null) {
            sslContextConfig.setKeyStoreFile(keystoreUrl.getFile());
            sslContextConfig.setKeyStorePass("changeit");
        }
        return new SSLEngineConfigurator(sslContextConfig.createSSLContext(), false, false, false);
    }
}

