/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.samples.portunif;

import java.io.IOException;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.filterchain.Filter;
import org.glassfish.grizzly.filterchain.FilterChainBuilder;
import org.glassfish.grizzly.filterchain.TransportFilter;
import org.glassfish.grizzly.http.server.AddOn;
import org.glassfish.grizzly.http.server.HttpHandler;
import org.glassfish.grizzly.http.server.HttpServer;
import org.glassfish.grizzly.http.server.NetworkListener;
import org.glassfish.grizzly.http.server.Request;
import org.glassfish.grizzly.http.server.Response;
import org.glassfish.grizzly.portunif.PUFilter;
import org.glassfish.grizzly.portunif.PUProtocol;
import org.glassfish.grizzly.samples.portunif.PUServer;

public class HttpPUServer {
    public static void main(String[] args) throws IOException {
        HttpServer httpServer = new HttpServer();
        NetworkListener networkListener = new NetworkListener("pu-http-server", "0.0.0.0", 17400);
        networkListener.registerAddOn((AddOn)new PortUnificationAddOn());
        httpServer.addListener(networkListener);
        httpServer.getServerConfiguration().addHttpHandler(new HttpHandler(){

            public void service(Request request, Response response) throws Exception {
                response.getWriter().write("Hello world from HTTP!");
            }
        });
        httpServer.start();
        try {
            Grizzly.logger(HttpPUServer.class).info("Server is ready...\nYou can test it using AddClient, SubClient applications or web browser\nPress enter to exit.");
            System.in.read();
        }
        finally {
            httpServer.shutdownNow();
        }
    }

    public static class PortUnificationAddOn
    implements AddOn {
        public void setup(NetworkListener networkListener, FilterChainBuilder builder) {
            PUFilter puFilter = new PUFilter(false);
            PUProtocol addProtocol = PUServer.configureAddProtocol(puFilter);
            PUProtocol subProtocol = PUServer.configureSubProtocol(puFilter);
            puFilter.register(addProtocol);
            puFilter.register(subProtocol);
            int transportFilterIdx = builder.indexOfType(TransportFilter.class);
            assert (transportFilterIdx != -1);
            builder.add(transportFilterIdx + 1, (Filter)puFilter);
        }
    }
}

