/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.samples.portunif;

import java.io.IOException;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.Processor;
import org.glassfish.grizzly.filterchain.Filter;
import org.glassfish.grizzly.filterchain.FilterChain;
import org.glassfish.grizzly.filterchain.FilterChainBuilder;
import org.glassfish.grizzly.filterchain.TransportFilter;
import org.glassfish.grizzly.nio.transport.TCPNIOTransport;
import org.glassfish.grizzly.nio.transport.TCPNIOTransportBuilder;
import org.glassfish.grizzly.portunif.PUFilter;
import org.glassfish.grizzly.portunif.PUProtocol;
import org.glassfish.grizzly.portunif.ProtocolFinder;
import org.glassfish.grizzly.samples.portunif.addservice.AddProtocolFinder;
import org.glassfish.grizzly.samples.portunif.addservice.AddServerMessageFilter;
import org.glassfish.grizzly.samples.portunif.addservice.AddServiceFilter;
import org.glassfish.grizzly.samples.portunif.subservice.SubProtocolFinder;
import org.glassfish.grizzly.samples.portunif.subservice.SubServerMessageFilter;
import org.glassfish.grizzly.samples.portunif.subservice.SubServiceFilter;

public class PUServer {
    static final int PORT = 17400;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException {
        PUFilter puFilter = new PUFilter();
        PUProtocol addProtocol = PUServer.configureAddProtocol(puFilter);
        PUProtocol subProtocol = PUServer.configureSubProtocol(puFilter);
        puFilter.register(addProtocol);
        puFilter.register(subProtocol);
        FilterChainBuilder puFilterChainBuilder = FilterChainBuilder.stateless().add((Filter)new TransportFilter()).add((Filter)puFilter);
        TCPNIOTransport transport = TCPNIOTransportBuilder.newInstance().build();
        transport.setProcessor((Processor)puFilterChainBuilder.build());
        try {
            transport.bind(17400);
            transport.start();
            Grizzly.logger(PUServer.class).info("Server is ready...\nPress enter to exit.");
            System.in.read();
        }
        finally {
            transport.shutdownNow();
        }
    }

    static PUProtocol configureAddProtocol(PUFilter puFilter) {
        AddProtocolFinder addProtocolFinder = new AddProtocolFinder();
        FilterChain addProtocolFilterChain = puFilter.getPUFilterChainBuilder().add((Filter)new AddServerMessageFilter()).add((Filter)new AddServiceFilter()).build();
        return new PUProtocol((ProtocolFinder)addProtocolFinder, addProtocolFilterChain);
    }

    static PUProtocol configureSubProtocol(PUFilter puFilter) {
        SubProtocolFinder subProtocolFinder = new SubProtocolFinder();
        FilterChain subProtocolFilterChain = puFilter.getPUFilterChainBuilder().add((Filter)new SubServerMessageFilter()).add((Filter)new SubServiceFilter()).build();
        return new PUProtocol((ProtocolFinder)subProtocolFinder, subProtocolFilterChain);
    }
}

