/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.samples.portunif;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.concurrent.TimeUnit;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.GrizzlyFuture;
import org.glassfish.grizzly.Processor;
import org.glassfish.grizzly.WriteResult;
import org.glassfish.grizzly.filterchain.BaseFilter;
import org.glassfish.grizzly.filterchain.Filter;
import org.glassfish.grizzly.filterchain.FilterChainBuilder;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.filterchain.NextAction;
import org.glassfish.grizzly.filterchain.TransportFilter;
import org.glassfish.grizzly.nio.transport.TCPNIOTransport;
import org.glassfish.grizzly.nio.transport.TCPNIOTransportBuilder;
import org.glassfish.grizzly.samples.portunif.PUServer;
import org.glassfish.grizzly.samples.portunif.addservice.AddClientMessageFilter;
import org.glassfish.grizzly.samples.portunif.addservice.AddRequestMessage;
import org.glassfish.grizzly.samples.portunif.addservice.AddResponseMessage;
import org.glassfish.grizzly.utils.Charsets;
import org.slf4j.Logger;

public class AddClient {
    private static final Logger LOGGER = Grizzly.logger(PUServer.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        Connection connection = null;
        FilterChainBuilder puFilterChainBuilder = FilterChainBuilder.stateless().add((Filter)new TransportFilter()).add((Filter)new AddClientMessageFilter()).add((Filter)new ResultFilter());
        TCPNIOTransport transport = TCPNIOTransportBuilder.newInstance().build();
        transport.setProcessor((Processor)puFilterChainBuilder.build());
        try {
            String line;
            transport.start();
            GrizzlyFuture connectFuture = transport.connect("localhost", 17400);
            connection = (Connection)connectFuture.get(10L, TimeUnit.SECONDS);
            LOGGER.info("Enter 2 numbers separated by space (<value1> <value2>) end press <enter>.");
            LOGGER.info("Type q and enter to exit.");
            BufferedReader reader = new BufferedReader(new InputStreamReader(System.in, Charsets.ASCII_CHARSET));
            while ((line = reader.readLine()) != null) {
                int value2;
                int value1;
                if ("q".equals(line)) {
                    break;
                }
                try {
                    String[] values = line.split(" ");
                    value1 = Integer.parseInt(values[0].trim());
                    value2 = Integer.parseInt(values[1].trim());
                }
                catch (Exception e) {
                    LOGGER.warn("Bad format, repeat pls");
                    continue;
                }
                GrizzlyFuture writeFuture = connection.write((Object)new AddRequestMessage(value1, value2));
                WriteResult result = (WriteResult)writeFuture.get(10L, TimeUnit.SECONDS);
                assert (result != null);
            }
        }
        finally {
            if (connection != null) {
                connection.closeSilently();
            }
            transport.shutdownNow();
        }
    }

    private static final class ResultFilter
    extends BaseFilter {
        private ResultFilter() {
        }

        public NextAction handleRead(FilterChainContext ctx) throws IOException {
            AddResponseMessage addResponseMessage = (AddResponseMessage)ctx.getMessage();
            LOGGER.info("Result={}", (Object)addResponseMessage.getResult());
            return ctx.getStopAction();
        }
    }
}

