/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.framework;

import java.util.List;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.MockitoSession;
import org.mockito.exceptions.misusing.RedundantListenerException;
import org.mockito.internal.exceptions.Reporter;
import org.mockito.internal.junit.TestFinishedEvent;
import org.mockito.internal.junit.UniversalTestListener;
import org.mockito.plugins.MockitoLogger;
import org.mockito.quality.Strictness;

public class DefaultMockitoSession
implements MockitoSession {
    private final String name;
    private final UniversalTestListener listener;

    public DefaultMockitoSession(List<Object> testClassInstances, String name, Strictness strictness, MockitoLogger logger) {
        this.name = name;
        this.listener = new UniversalTestListener(strictness, logger);
        try {
            Mockito.framework().addListener(this.listener);
        }
        catch (RedundantListenerException e) {
            Reporter.unfinishedMockingSession();
        }
        try {
            for (Object testClassInstance : testClassInstances) {
                MockitoAnnotations.initMocks(testClassInstance);
            }
        }
        catch (RuntimeException e) {
            this.listener.setListenerDirty();
            throw e;
        }
    }

    @Override
    public void setStrictness(Strictness strictness) {
        this.listener.setStrictness(strictness);
    }

    @Override
    public void finishMocking() {
        this.finishMocking(null);
    }

    @Override
    public void finishMocking(final Throwable failure) {
        Mockito.framework().removeListener(this.listener);
        this.listener.testFinished(new TestFinishedEvent(){

            @Override
            public Throwable getFailure() {
                return failure;
            }

            @Override
            public String getTestName() {
                return DefaultMockitoSession.this.name;
            }
        });
        if (failure == null) {
            Mockito.validateMockitoUsage();
        }
    }
}

