/*
 * Copyright © MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.apikit.scaffolding.internal;

import java.util.List;
import java.util.Random;

public class DWUtils {

  private static final Random random = new Random();

  public static <T> T choose(List<T> values) {
    int index = random.nextInt(values.size());
    return values.get(index);
  }

  public static void setSeed(long seed) {
    random.setSeed(seed);
  }
}
