/*
 * Decompiled with CFR 0.152.
 */
package org.mule.amf.impl;

import amf.apicontract.client.platform.model.domain.api.WebApi;
import amf.core.client.platform.execution.ExecutionEnvironment;
import amf.core.client.platform.model.document.BaseUnit;
import amf.core.client.platform.model.document.Document;
import amf.core.client.platform.validation.AMFValidationReport;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.stream.Collectors;
import org.mule.amf.impl.model.AMFImpl;
import org.mule.amf.impl.parser.factory.AMFParserWrapper;
import org.mule.amf.impl.parser.rule.ApiValidationResultImpl;
import org.mule.amf.impl.util.LazyValue;
import org.mule.apikit.ApiParser;
import org.mule.apikit.model.ApiSpecification;
import org.mule.apikit.model.api.ApiReference;
import org.mule.apikit.validation.ApiValidationReport;
import org.mule.apikit.validation.DefaultApiValidationReport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AMFParser
implements ApiParser {
    private static final Logger logger = LoggerFactory.getLogger(AMFParser.class);
    private URI apiUri;
    private ApiReference apiRef;
    private AMFParserWrapper parser;
    private LazyValue<WebApi> webApi;
    private LazyValue<Document> document;
    private ExecutionEnvironment executionEnvironment;

    @Deprecated
    public AMFParser(ApiReference apiRef, boolean validate, ScheduledExecutorService scheduler) {
        this.initializeParser(apiRef, new ExecutionEnvironment(scheduler));
    }

    @Deprecated
    public AMFParser(ApiReference apiRef, boolean validate) {
        this.initializeParser(apiRef, new ExecutionEnvironment());
    }

    public AMFParser(ApiReference apiRef, ScheduledExecutorService scheduler) {
        this.initializeParser(apiRef, new ExecutionEnvironment(scheduler));
    }

    public AMFParser(ApiReference apiRef) {
        this.initializeParser(apiRef, new ExecutionEnvironment());
    }

    private void initializeParser(ApiReference apiRef, ExecutionEnvironment executionEnvironment) {
        this.executionEnvironment = executionEnvironment;
        this.apiUri = apiRef.getPathAsUri();
        this.document = new LazyValue<Document>(() -> this.parser.parseApi());
        this.webApi = new LazyValue<WebApi>(() -> (WebApi)this.document.get().encodes());
        this.apiRef = apiRef;
        this.parser = AMFParser.getParser(apiRef, executionEnvironment);
    }

    public static AMFParserWrapper getParser(ApiReference apiRef, ExecutionEnvironment execEnv) {
        if (execEnv == null) {
            throw new RuntimeException("ExecutionEnvironment is mandatory");
        }
        return new AMFParserWrapper(apiRef, execEnv);
    }

    private List<String> getReferences(List<BaseUnit> references) {
        ArrayList<String> result = new ArrayList<String>();
        this.appendReferences(references, new HashSet<String>(), result);
        return result;
    }

    private void appendReferences(List<BaseUnit> references, Set<String> alreadyAdded, List<String> result) {
        for (BaseUnit reference : references) {
            String id = reference.id();
            if (alreadyAdded.contains(id)) continue;
            String location = reference.location();
            result.add(location);
            alreadyAdded.add(id);
            this.appendReferences(reference.references(), alreadyAdded, result);
        }
    }

    public WebApi getWebApi() {
        return this.webApi.get();
    }

    public ApiValidationReport validate() {
        AMFValidationReport validationReport = this.parser.getParsingReport(this.document.get());
        List<Object> results = new ArrayList(0);
        if (!validationReport.conforms()) {
            results = validationReport.results().stream().map(ApiValidationResultImpl::new).collect(Collectors.toList());
        }
        results.addAll(this.parser.getParsingIssues().stream().map(ApiValidationResultImpl::new).collect(Collectors.toList()));
        return new DefaultApiValidationReport(results);
    }

    public ApiSpecification parse() {
        AMFParserWrapper parserWrapper = AMFParser.getParser(this.apiRef, this.executionEnvironment);
        return new AMFImpl(this.webApi.get(), this.getReferences(this.document.get().references()), parserWrapper, this.apiRef.getVendor(), this.apiRef.getLocation(), this.apiUri);
    }
}

