/*
 * Decompiled with CFR 0.152.
 */
package org.mule.amf.impl.loader;

import amf.core.client.common.remote.Content;
import amf.core.client.platform.resource.ResourceLoader;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.concurrent.CompletableFuture;
import org.apache.commons.io.IOUtils;

public class ProvidedResourceLoader
implements ResourceLoader {
    private org.mule.apikit.loader.ResourceLoader resourceLoader;

    public ProvidedResourceLoader(org.mule.apikit.loader.ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public CompletableFuture<Content> fetch(String resourceName) {
        CompletableFuture<Content> future = new CompletableFuture<Content>();
        if (resourceName == null || resourceName.isEmpty()) {
            throw new RuntimeException("Failed to apply.");
        }
        URI resource = this.resourceLoader.getResource(resourceName);
        if (resource != null) {
            InputStream stream = this.resourceLoader.getResourceAsStream(resourceName);
            try {
                String resourceAsString = IOUtils.toString((InputStream)stream);
                Content content = new Content(resourceAsString, resourceName);
                future.complete(content);
            }
            catch (IOException e) {
                future.completeExceptionally(new RuntimeException("Failed to fetch resource '" + resourceName + "'"));
            }
        } else {
            future.completeExceptionally(new Exception("Failed to fetch resource '" + resourceName + "'"));
        }
        return future;
    }
}

