/*
 * Decompiled with CFR 0.152.
 */
package org.mule.amf.impl.model;

import amf.apicontract.client.platform.AMFConfiguration;
import amf.shapes.client.platform.model.domain.AnyShape;
import amf.shapes.client.platform.model.domain.ArrayShape;
import amf.shapes.client.platform.model.domain.UnionShape;
import java.util.Collection;
import org.apache.commons.collections.CollectionUtils;
import org.mule.amf.impl.model.JsonParameterValidationStrategy;
import org.mule.amf.impl.model.ParameterValidationStrategy;
import org.mule.amf.impl.model.YamlParameterValidationStrategy;

class ParameterValidationStrategyFactory {
    private ParameterValidationStrategyFactory() {
        throw new IllegalStateException("Utility class");
    }

    static ParameterValidationStrategy getStrategy(AnyShape anyShape, boolean needsCharEscaping, AMFConfiguration amfConfiguration) {
        return ParameterValidationStrategyFactory.isYamlValidationNeeded(anyShape) ? new YamlParameterValidationStrategy(anyShape, needsCharEscaping, amfConfiguration) : ParameterValidationStrategyFactory.getJsonParameterValidationStrategy(anyShape, needsCharEscaping, amfConfiguration);
    }

    private static JsonParameterValidationStrategy getJsonParameterValidationStrategy(AnyShape anyShape, boolean needsCharsEscaping, AMFConfiguration amfConfiguration) {
        return new JsonParameterValidationStrategy(amfConfiguration.elementClient(), anyShape, needsCharsEscaping);
    }

    private static boolean isYamlValidationNeeded(AnyShape anyShape) {
        return anyShape instanceof ArrayShape || anyShape instanceof UnionShape || CollectionUtils.isNotEmpty((Collection)anyShape.or()) || CollectionUtils.isNotEmpty((Collection)anyShape.and()) || CollectionUtils.isNotEmpty((Collection)anyShape.xone()) || anyShape.not() != null;
    }
}

