/*
 * Decompiled with CFR 0.152.
 */
package org.mule.amf.impl.model;

import amf.apicontract.client.platform.AMFConfiguration;
import amf.core.client.common.validation.ValidationMode;
import amf.core.client.platform.model.domain.PropertyShape;
import amf.core.client.platform.model.domain.Shape;
import amf.core.client.platform.validation.AMFValidationReport;
import amf.core.client.platform.validation.payload.AMFShapePayloadValidator;
import amf.shapes.client.platform.model.domain.AnyShape;
import amf.shapes.client.platform.model.domain.ArrayShape;
import amf.shapes.client.platform.model.domain.NodeShape;
import amf.shapes.client.platform.model.domain.ScalarShape;
import amf.shapes.client.platform.model.domain.UnionShape;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.mule.amf.impl.model.MediaType;
import org.mule.amf.impl.model.ParameterImpl;
import org.mule.apikit.ParserUtils;
import org.mule.apikit.model.QueryString;
import org.mule.apikit.model.parameter.Parameter;

public class QueryStringImpl
implements QueryString {
    private final AMFConfiguration amfConfiguration;
    private AnyShape schema;
    private final Map<String, AMFShapePayloadValidator> payloadValidatorMap = new HashMap<String, AMFShapePayloadValidator>();
    private final String defaultMediaType = "application/yaml";

    public QueryStringImpl(AnyShape anyShape, AMFConfiguration amfConfiguration) {
        this.schema = anyShape;
        this.amfConfiguration = amfConfiguration;
    }

    public String getDefaultValue() {
        return this.schema.defaultValueStr().option().orElse(null);
    }

    public boolean isArray() {
        return this.schema instanceof ArrayShape;
    }

    public boolean validate(String value) {
        return this.validatePayload(value).conforms();
    }

    public boolean validate(Map<String, Collection<?>> queryParams) {
        String queryStringYaml = ParserUtils.queryStringAsYamlValue(this.facets(), queryParams);
        if (queryStringYaml.isEmpty()) {
            return this.validate("{}");
        }
        return this.validate(queryStringYaml);
    }

    private AMFValidationReport validatePayload(String value) {
        AMFShapePayloadValidator payloadValidator;
        String mimeType = MediaType.getMimeTypeForValue(value);
        if (!this.payloadValidatorMap.containsKey(mimeType)) {
            payloadValidator = this.amfConfiguration.elementClient().payloadValidatorFor((Shape)this.schema, mimeType, ValidationMode.StrictValidationMode());
            if (payloadValidator == null) {
                payloadValidator = this.amfConfiguration.elementClient().payloadValidatorFor((Shape)this.schema, "application/yaml", ValidationMode.StrictValidationMode());
            }
            this.payloadValidatorMap.put(mimeType, payloadValidator);
        } else {
            payloadValidator = this.payloadValidatorMap.get(mimeType);
        }
        if (payloadValidator != null) {
            return payloadValidator.syncValidate(value);
        }
        throw new RuntimeException("Unexpected Error validating request");
    }

    public boolean isScalar() {
        return this.schema instanceof ScalarShape;
    }

    public boolean isFacetArray(String facet) {
        if (this.schema instanceof NodeShape) {
            for (PropertyShape type : ((NodeShape)this.schema).properties()) {
                if (!facet.equals(type.name().value())) continue;
                return type.range() instanceof ArrayShape;
            }
        }
        return false;
    }

    public Map<String, Parameter> facets() {
        HashMap<String, Parameter> result = new HashMap<String, Parameter>();
        for (Shape schema : this.getSchemas()) {
            if (!(schema instanceof NodeShape)) continue;
            for (PropertyShape type : ((NodeShape)schema).properties()) {
                result.put(type.name().value(), new ParameterImpl(type, this.amfConfiguration));
            }
        }
        return result;
    }

    private List<Shape> getSchemas() {
        if (this.schema instanceof UnionShape) {
            return ((UnionShape)this.schema).anyOf();
        }
        if (this.schema instanceof ArrayShape) {
            return Collections.singletonList(((ArrayShape)this.schema).items());
        }
        return Collections.singletonList(this.schema);
    }
}

