/*
 * Decompiled with CFR 0.152.
 */
package org.mule.amf.impl.parser.factory;

import amf.apicontract.client.platform.AMFBaseUnitClient;
import amf.apicontract.client.platform.AMFConfiguration;
import amf.apicontract.client.platform.APIConfiguration;
import amf.core.client.common.transform.PipelineId;
import amf.core.client.platform.AMFParseResult;
import amf.core.client.platform.config.RenderOptions;
import amf.core.client.platform.execution.BaseExecutionEnvironment;
import amf.core.client.platform.execution.ExecutionEnvironment;
import amf.core.client.platform.model.document.BaseUnit;
import amf.core.client.platform.model.document.Document;
import amf.core.client.platform.resource.ResourceLoader;
import amf.core.client.platform.validation.AMFValidationReport;
import amf.core.client.platform.validation.AMFValidationResult;
import amf.core.internal.remote.Spec;
import java.io.File;
import java.net.URI;
import java.net.URLDecoder;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.mule.amf.impl.exceptions.ParserException;
import org.mule.amf.impl.loader.ExchangeDependencyResourceLoader;
import org.mule.amf.impl.loader.ProvidedResourceLoader;
import org.mule.apikit.model.api.ApiReference;
import org.yaml.builder.JsonOutputBuilder;

public class AMFParserWrapper {
    private final BaseUnit model;
    private final AMFBaseUnitClient client;
    private final Spec spec;
    private final List<AMFValidationResult> parsingIssues;
    private final AMFConfiguration apiConfiguration;

    public AMFParserWrapper(ApiReference apiRef, ExecutionEnvironment execEnv) {
        URI apiUri;
        AMFConfiguration amfConfiguration = APIConfiguration.API().withExecutionEnvironment((BaseExecutionEnvironment)execEnv);
        if (apiRef.getResourceLoader().isPresent()) {
            amfConfiguration = amfConfiguration.withResourceLoader((ResourceLoader)new ProvidedResourceLoader((org.mule.apikit.loader.ResourceLoader)apiRef.getResourceLoader().get()));
        }
        if ((apiUri = apiRef.getPathAsUri()).getScheme() != null && apiUri.getScheme().startsWith("file")) {
            File file = new File(apiUri);
            String rootDir = file.isDirectory() ? file.getPath() : file.getParent();
            amfConfiguration = amfConfiguration.withResourceLoader((ResourceLoader)new ExchangeDependencyResourceLoader(rootDir, execEnv));
        }
        AMFParseResult amfParseResult = (AMFParseResult)this.handleFuture(amfConfiguration.baseUnitClient().parse(URLDecoder.decode(apiRef.getPathAsUri().toString())));
        this.parsingIssues = amfParseResult.results();
        this.model = amfParseResult.baseUnit();
        this.spec = amfParseResult.sourceSpec();
        this.apiConfiguration = APIConfiguration.fromSpec((Spec)this.spec).withExecutionEnvironment((BaseExecutionEnvironment)execEnv);
        this.client = this.apiConfiguration.baseUnitClient();
    }

    public Document parseApi() throws ParserException {
        return (Document)this.client.transform(this.model, PipelineId.Editing()).baseUnit();
    }

    public AMFValidationReport getParsingReport(Document resolvedDoc) throws ParserException {
        AMFValidationReport report = (AMFValidationReport)this.handleFuture(this.client.validate((BaseUnit)resolvedDoc));
        return report;
    }

    private <T, U> U handleFuture(CompletableFuture<T> f) throws ParserException {
        try {
            return (U)f.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw AMFParserWrapper.getParseException(e);
        }
        catch (Exception e) {
            throw AMFParserWrapper.getParseException(e);
        }
    }

    private static ParserException getParseException(Exception e) {
        throw new ParserException("An error happened while parsing the api. Message: " + e.getMessage(), e);
    }

    public String renderApi(Document document) {
        return this.getRenderClient().render((BaseUnit)document);
    }

    public AMFBaseUnitClient getRenderClient() {
        RenderOptions renderOptions = new RenderOptions().withoutSourceMaps().withoutPrettyPrint().withCompactUris();
        return this.getApiConfiguration().withRenderOptions(renderOptions).baseUnitClient();
    }

    public <W> void renderApi(Document document, JsonOutputBuilder<W> wJsonOutputBuilder) {
        this.getRenderClient().renderGraphToBuilder((BaseUnit)document, wJsonOutputBuilder);
    }

    public Spec getSpec() {
        return this.spec;
    }

    public AMFConfiguration getApiConfiguration() {
        return this.apiConfiguration;
    }

    public List<AMFValidationResult> getParsingIssues() {
        return this.parsingIssues;
    }
}

