/*
 * Decompiled with CFR 0.152.
 */
package org.mule.distributions.tests;

import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.rules.RuleChain;
import org.junit.rules.TemporaryFolder;
import org.junit.rules.TestRule;
import org.mule.distributions.tests.DistributionFinder;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.junit4.rule.SystemProperty;
import org.mule.tck.probe.JUnitLambdaProbe;
import org.mule.tck.probe.PollingProber;
import org.mule.tck.probe.Probe;
import org.mule.tck.probe.Prober;
import org.mule.test.infrastructure.process.MuleProcessController;
import org.mule.test.infrastructure.process.MuleStatusProbe;
import org.mule.test.infrastructure.process.rules.MuleDeployment;
import org.mule.test.infrastructure.process.rules.MuleInstallation;
import org.mule.test.infrastructure.process.rules.MuleServerFailureLogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractAppControl
extends AbstractMuleTestCase {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractAppControl.class);
    public static final String LOCAL_REPOSITORY = "localRepository";
    protected static MuleProcessController mule;
    protected static MuleInstallation installation;
    private static Prober prober;
    private static int timeout;
    private static final Thread shutdownHookThread;
    @ClassRule
    public static TestRule chain;
    @Rule
    public SystemProperty muleHomeProp = new SystemProperty("mule.home", installation.getMuleHome());
    @ClassRule
    public static TemporaryFolder temporaryFolder;

    @BeforeClass
    public static void setUp() {
        LOGGER.info("Distribution: " + System.getProperty("mule.distribution"));
        String muleHome = installation.getMuleHome();
        mule = new MuleProcessController(muleHome, (int)TimeUnit.SECONDS.toMillis(timeout));
        AbstractAppControl.addShutdownHooks();
        LOGGER.info("MULE_HOME: " + muleHome);
    }

    @AfterClass
    public static void stopMule() {
        mule.stop(new String[0]);
        AbstractAppControl.assertMuleStops();
        AbstractAppControl.removeShutdownHooks();
    }

    protected static String getSystemOrEnvProperty(String key) {
        return AbstractAppControl.getSystemOrEnvProperty(key, null);
    }

    private static String getSystemOrEnvProperty(String key, String def) {
        String property = System.getProperty(key);
        if (property == null) {
            property = System.getenv(key);
        }
        return property != null ? property : def;
    }

    protected static void assertAppIsDeployed(String appName) {
        prober.check((Probe)new JUnitLambdaProbe(() -> mule.isDeployed(appName), () -> "Application [" + appName + "] is not deployed."));
    }

    protected static void assertAppNotDeployed(String appName) {
        Assert.assertFalse((boolean)mule.isDeployed(appName));
    }

    protected static void assertDomainIsDeployed(String domainName) {
        prober.check((Probe)new JUnitLambdaProbe(() -> mule.isDomainDeployed(domainName), () -> "Domain [" + domainName + "] is not deployed."));
    }

    protected static void assertDomainNotDeployed(String domainName) {
        Assert.assertFalse((boolean)mule.isDomainDeployed(domainName));
    }

    protected static void assertMuleStops() {
        prober.check(MuleStatusProbe.isNotRunning((MuleProcessController)mule));
    }

    protected static void assertMuleStarts() {
        prober.check(MuleStatusProbe.isRunning((MuleProcessController)mule));
    }

    protected static long getDeploymentTimeout() {
        String TIMEOUT = System.getProperty("mule.test.deployment.timeout");
        return TIMEOUT == null ? 300000L : (long)Integer.parseInt(TIMEOUT);
    }

    public static MuleDeployment.Builder builderWithDefaultConfig() {
        MuleDeployment.Builder builder = MuleDeployment.builder();
        builder.withProperties(AbstractAppControl.getDefaultArguments());
        return builder;
    }

    protected static String[] getArgumentsIncludingDefaults(Boolean addRepositoryLocation, String ... arguments) {
        Optional<String> localRepository = AbstractAppControl.getLocalRepository();
        for (Map.Entry<Object, Object> sysPropEntry : System.getProperties().entrySet()) {
            String key = (String)sysPropEntry.getKey();
            if (!key.startsWith("-M")) continue;
            arguments = (String[])ArrayUtils.add((Object[])arguments, (Object)(key + "=" + sysPropEntry.getValue()));
        }
        if (localRepository.isPresent() && addRepositoryLocation.booleanValue()) {
            arguments = (String[])ArrayUtils.addAll((Object[])arguments, (Object[])new String[]{"-M-DmuleRuntimeConfig.maven.repositoryLocation=" + localRepository.get()});
        }
        return (String[])ArrayUtils.addAll((Object[])arguments, (Object[])new String[]{"-M-DmuleRuntimeConfig.maven.repositories.mavenCentral.url=https://repo.maven.apache.org/maven2/", "-M-DmuleRuntimeConfig.maven.repositories.muleSoftPublic.url=https://repository.mulesoft.org/nexus/content/repositories/public/", "-M-Dmule.verbose.exceptions=true"});
    }

    public static String[] getArgumentsIncludingDefaults(String ... arguments) {
        return AbstractAppControl.getArgumentsIncludingDefaults(true, arguments);
    }

    protected static Map<String, String> getDefaultArguments() {
        return Arrays.stream(AbstractAppControl.getArgumentsIncludingDefaults(new String[0])).map(property -> property.split("=")).collect(Collectors.toMap(e -> e[0], e -> e[1]));
    }

    protected static Optional<String> getLocalRepository() {
        String localRepository = System.getProperty(LOCAL_REPOSITORY);
        if (localRepository != null) {
            return Optional.of(localRepository);
        }
        return Optional.empty();
    }

    private static void addShutdownHooks() {
        Runtime.getRuntime().addShutdownHook(shutdownHookThread);
    }

    private static void removeShutdownHooks() {
        Runtime.getRuntime().removeShutdownHook(shutdownHookThread);
    }

    public static MuleProcessController getMule() {
        return mule;
    }

    static {
        installation = new MuleInstallation(DistributionFinder.findDistribution());
        prober = new PollingProber(AbstractAppControl.getDeploymentTimeout(), 1000L);
        timeout = Integer.parseInt(System.getProperty("mule.test.timeoutSecs", Integer.toString(60)));
        shutdownHookThread = new Thread(() -> AbstractAppControl.stopMule());
        chain = RuleChain.outerRule((TestRule)installation).around((TestRule)new MuleServerFailureLogger(installation));
        temporaryFolder = new TemporaryFolder();
    }
}

