/*
 * Decompiled with CFR 0.152.
 */
package org.mule.mvel2.sh.command.file;

import java.io.File;
import org.mule.mvel2.sh.Command;
import org.mule.mvel2.sh.CommandException;
import org.mule.mvel2.sh.ShellSession;

public class ChangeWorkingDir
implements Command {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object execute(ShellSession session, String[] args) {
        File cwd = new File(session.getEnv().get("$CWD"));
        if (args.length == 0 || ".".equals(args[0])) {
            return null;
        }
        if ("..".equals(args[0])) {
            if (cwd.getParentFile() == null) throw new CommandException("already at top-level directory");
            cwd = cwd.getParentFile();
        } else if (args[0].charAt(0) == '/' ? !(cwd = new File(args[0])).exists() : !(cwd = new File(cwd.getAbsolutePath() + "/" + args[0])).exists()) {
            throw new CommandException("no such directory: " + args[0]);
        }
        session.getEnv().put("$CWD", cwd.getAbsolutePath());
        return null;
    }

    public String getDescription() {
        return "changes the working directory";
    }

    public String getHelp() {
        return "no help yet";
    }
}

