/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.spring;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections.map.HashedMap;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.component.location.Location;
import org.mule.runtime.api.meta.AnnotatedObject;
import org.mule.runtime.core.api.locator.ConfigurationComponentLocator;

public class SpringConfigurationComponentLocator
implements ConfigurationComponentLocator {
    private Map<String, AnnotatedObject> componentsMap = new HashedMap();

    public void addComponent(AnnotatedObject component) {
        this.componentsMap.put(component.getLocation().getLocation(), component);
    }

    @Override
    public Optional<AnnotatedObject> find(Location location) {
        return Optional.ofNullable(this.componentsMap.get(location.toString()));
    }

    @Override
    public List<AnnotatedObject> find(ComponentIdentifier componentIdentifier) {
        return this.componentsMap.values().stream().filter(component -> component.getLocation().getComponentIdentifier().getIdentifier().equals(componentIdentifier)).collect(Collectors.toList());
    }
}

