/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.spring.factories;

import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import javax.xml.namespace.QName;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.lifecycle.Startable;
import org.mule.runtime.api.meta.AbstractAnnotatedObject;
import org.mule.runtime.api.meta.AnnotatedObject;
import org.mule.runtime.core.DefaultEventContext;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.construct.Flow;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.construct.FlowConstructAware;
import org.mule.runtime.core.api.context.MuleContextAware;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.processor.MessageProcessorChain;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.config.i18n.CoreMessages;
import org.mule.runtime.core.exception.MessagingException;
import org.mule.runtime.core.processor.AnnotatedProcessor;
import org.mule.runtime.core.processor.chain.AbstractMessageProcessorChain;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import reactor.core.publisher.Flux;

public class FlowRefFactoryBean
extends AbstractAnnotatedObject
implements FactoryBean<Processor>,
ApplicationContextAware,
MuleContextAware,
Initialisable {
    private static final Logger LOGGER = LoggerFactory.getLogger(FlowRefFactoryBean.class);
    private static final String NULL_FLOW_CONTRUCT_NAME = "null";
    private static final String MULE_PREFIX = "_mule-";
    private String refName;
    private ApplicationContext applicationContext;
    private MuleContext muleContext;
    private Processor referencedMessageProcessor;
    private ConcurrentMap<String, Processor> referenceCache = new ConcurrentHashMap<String, Processor>();
    private boolean wasInitialized = false;

    public void setName(String name) {
        this.refName = name;
    }

    @Override
    public void initialise() throws InitialisationException {
        if (this.wasInitialized) {
            return;
        }
        if (this.refName.isEmpty()) {
            throw new InitialisationException(CoreMessages.objectIsNull("flow reference is empty"), (Initialisable)this);
        }
        if (!this.muleContext.getExpressionManager().isExpression(this.refName)) {
            this.referencedMessageProcessor = this.lookupReferencedFlowInApplicationContext(this.refName);
        }
        this.wasInitialized = true;
    }

    public Processor getObject() throws Exception {
        this.initialise();
        Processor processor = this.referencedMessageProcessor != null ? this.referencedMessageProcessor : this.createDynamicReferenceMessageProcessor(this.refName);
        return new AbstractMessageProcessorChain(Collections.singletonList(processor)){

            @Override
            public void stop() throws MuleException {
                super.stop();
                LifecycleUtils.stopIfNeeded(FlowRefFactoryBean.this.referenceCache.values());
            }

            @Override
            public void dispose() {
                super.dispose();
                LifecycleUtils.disposeIfNeeded(FlowRefFactoryBean.this.referenceCache.values(), LOGGER);
                FlowRefFactoryBean.this.referenceCache = null;
            }
        };
    }

    protected Processor createDynamicReferenceMessageProcessor(String name) throws MuleException {
        if (name == null) {
            throw new MuleRuntimeException(CoreMessages.objectIsNull(name));
        }
        if (!this.referenceCache.containsKey(name)) {
            FlowRefMessageProcessorContainer dynamicReference = new FlowRefMessageProcessorContainer(){

                @Override
                public Event process(Event event) throws MuleException {
                    try {
                        Processor dynamicMessageProcessor = this.resolveReferencedProcessor(event);
                        return FlowRefFactoryBean.this.createParentEvent(event, ((Processor)event1 -> dynamicMessageProcessor.process(event1)).process(FlowRefFactoryBean.this.createChildEvent(event)));
                    }
                    catch (MessagingException me) {
                        me.setProcessedEvent(FlowRefFactoryBean.this.createParentEvent(event, me.getEvent()));
                        throw me;
                    }
                }

                @Override
                public Publisher<Event> apply(Publisher<Event> publisher) {
                    return Flux.from(publisher).flatMap(event -> {
                        Processor referencedProcessor;
                        try {
                            referencedProcessor = this.resolveReferencedProcessor((Event)event);
                        }
                        catch (MuleException e) {
                            return Flux.error((Throwable)e);
                        }
                        if (referencedProcessor instanceof Flow) {
                            Event childEvent = FlowRefFactoryBean.this.createChildEvent(event);
                            Flux.just((Object)childEvent).transform((Function)referencedProcessor).subscribe(null, throwable -> {});
                            return Flux.from(childEvent.getContext().getResponsePublisher()).map(result -> Event.builder(event.getContext(), result).build()).doOnError(MessagingException.class, me -> me.setProcessedEvent(FlowRefFactoryBean.this.createParentEvent(event, me.getEvent())));
                        }
                        return Flux.just((Object)event).transform((Function)referencedProcessor);
                    });
                }

                private Processor resolveReferencedProcessor(Event event) throws MuleException {
                    String flowName = FlowRefFactoryBean.this.muleContext.getExpressionManager().parse(FlowRefFactoryBean.this.refName, event, this.flowConstruct);
                    Processor dynamicMessageProcessor = FlowRefFactoryBean.this.getReferencedFlow(flowName, this.flowConstruct);
                    this.setResolvedMessageProcessor(dynamicMessageProcessor);
                    return dynamicMessageProcessor;
                }

                @Override
                public Object getAnnotation(QName name) {
                    return FlowRefFactoryBean.this.getAnnotation(name);
                }

                @Override
                public Map<QName, Object> getAnnotations() {
                    return FlowRefFactoryBean.this.getAnnotations();
                }

                @Override
                public ComponentLocation getLocation() {
                    return FlowRefFactoryBean.this.getLocation();
                }
            };
            if (dynamicReference instanceof Initialisable) {
                ((Initialisable)((Object)dynamicReference)).initialise();
            }
            this.referenceCache.putIfAbsent(name, dynamicReference);
        }
        return (Processor)this.referenceCache.get(name);
    }

    private Event createChildEvent(Event event) {
        return Event.builder(DefaultEventContext.child(event.getContext()), event).build();
    }

    private Event createParentEvent(Event parent, Event result) {
        return Event.builder(parent.getContext(), result).build();
    }

    protected Processor getReferencedFlow(String name, FlowConstruct flowConstruct) throws MuleException {
        if (name == null) {
            throw new MuleRuntimeException(CoreMessages.objectIsNull(name));
        }
        String categorizedName = this.getReferencedFlowCategorizedName(name, flowConstruct);
        if (!this.referenceCache.containsKey(categorizedName)) {
            Processor referencedFlow = this.lookupReferencedFlowInApplicationContext(name);
            if (referencedFlow instanceof Initialisable) {
                if (referencedFlow instanceof FlowConstructAware) {
                    ((FlowConstructAware)((Object)referencedFlow)).setFlowConstruct(flowConstruct);
                }
                if (referencedFlow instanceof MuleContextAware) {
                    ((MuleContextAware)((Object)referencedFlow)).setMuleContext(this.muleContext);
                }
                if (referencedFlow instanceof MessageProcessorChain) {
                    for (Processor processor : ((MessageProcessorChain)referencedFlow).getMessageProcessors()) {
                        if (processor instanceof FlowConstructAware) {
                            ((FlowConstructAware)((Object)processor)).setFlowConstruct(flowConstruct);
                        }
                        if (!(processor instanceof MuleContextAware)) continue;
                        ((MuleContextAware)((Object)processor)).setMuleContext(this.muleContext);
                    }
                }
                ((Initialisable)((Object)referencedFlow)).initialise();
            }
            if (referencedFlow instanceof Startable) {
                ((Startable)((Object)referencedFlow)).start();
            }
            this.referenceCache.putIfAbsent(categorizedName, referencedFlow);
        }
        return (Processor)this.referenceCache.get(categorizedName);
    }

    private String getReferencedFlowCategorizedName(String referencedFlowName, FlowConstruct flowConstruct) {
        String flowConstructName = flowConstruct != null ? flowConstruct.getName() : NULL_FLOW_CONTRUCT_NAME;
        return MULE_PREFIX + flowConstructName + "-" + referencedFlowName;
    }

    protected Processor lookupReferencedFlowInApplicationContext(String name) {
        final Processor referencedFlow = (Processor)this.applicationContext.getBean(name);
        if (referencedFlow == null) {
            throw new MuleRuntimeException(CoreMessages.objectIsNull(name));
        }
        if (referencedFlow instanceof Flow) {
            return new FlowRefMessageProcessor(){

                @Override
                public ComponentLocation getLocation() {
                    return FlowRefFactoryBean.this.getLocation();
                }

                @Override
                public Event process(Event event) throws MuleException {
                    try {
                        return FlowRefFactoryBean.this.createParentEvent(event, referencedFlow.process(FlowRefFactoryBean.this.createChildEvent(event)));
                    }
                    catch (MessagingException me) {
                        me.setProcessedEvent(FlowRefFactoryBean.this.createParentEvent(event, me.getEvent()));
                        throw me;
                    }
                }

                @Override
                public Publisher<Event> apply(Publisher<Event> publisher) {
                    return Flux.from(publisher).flatMap(event -> {
                        Event childEvent = FlowRefFactoryBean.this.createChildEvent(event);
                        Flux.just((Object)childEvent).transform((Function)referencedFlow).subscribe(null, throwable -> {});
                        return Flux.from(childEvent.getContext().getResponsePublisher()).map(result -> FlowRefFactoryBean.this.createParentEvent(event, result)).doOnError(MessagingException.class, me -> me.setProcessedEvent(FlowRefFactoryBean.this.createParentEvent(event, me.getEvent())));
                    });
                }
            };
        }
        if (referencedFlow instanceof AnnotatedObject) {
            ((AnnotatedObject)((Object)referencedFlow)).setAnnotations(this.getAnnotations());
        }
        return referencedFlow;
    }

    public boolean isSingleton() {
        return true;
    }

    public Class<?> getObjectType() {
        return Processor.class;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    @Override
    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
    }

    private abstract class FlowRefMessageProcessorContainer
    extends FlowRefMessageProcessor
    implements FlowConstructAware {
        private Processor dynamicMessageProcessor;

        private FlowRefMessageProcessorContainer() {
        }

        protected void setResolvedMessageProcessor(Processor dynamicMessageProcessor) {
            this.dynamicMessageProcessor = dynamicMessageProcessor;
        }

        @Override
        public Object getAnnotation(QName name) {
            return FlowRefFactoryBean.this.getAnnotation(name);
        }

        @Override
        public Map<QName, Object> getAnnotations() {
            return FlowRefFactoryBean.this.getAnnotations();
        }
    }

    private abstract class FlowRefMessageProcessor
    implements AnnotatedProcessor,
    FlowConstructAware {
        protected FlowConstruct flowConstruct;

        private FlowRefMessageProcessor() {
        }

        @Override
        public Object getAnnotation(QName name) {
            return FlowRefFactoryBean.this.getAnnotation(name);
        }

        @Override
        public Map<QName, Object> getAnnotations() {
            return FlowRefFactoryBean.this.getAnnotations();
        }

        @Override
        public void setAnnotations(Map<QName, Object> annotations) {
            FlowRefFactoryBean.this.setAnnotations(annotations);
        }

        @Override
        public void setFlowConstruct(FlowConstruct flowConstruct) {
            this.flowConstruct = flowConstruct;
        }
    }
}

