/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.spring.parsers.collection;

import org.mule.runtime.config.spring.parsers.AbstractChildDefinitionParser;
import org.mule.runtime.config.spring.parsers.collection.ChildListEntryDefinitionParser;
import org.mule.runtime.config.spring.parsers.collection.DynamicAttributeDefinitionParser;
import org.mule.runtime.config.spring.util.SpringXMLUtils;
import org.mule.runtime.core.api.util.StringUtils;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

public class AttributeListEntryDefinitionParser
extends AbstractChildDefinitionParser
implements DynamicAttributeDefinitionParser {
    private String setterMethod;
    private String attributeName;

    public AttributeListEntryDefinitionParser(String setterMethod) {
        this(setterMethod, null);
    }

    public AttributeListEntryDefinitionParser(String setterMethod, String attributeName) {
        this.setterMethod = setterMethod;
        this.setAttributeName(attributeName);
    }

    @Override
    public String getPropertyName(Element element) {
        return this.setterMethod;
    }

    protected Class getBeanClass(Element element) {
        return ChildListEntryDefinitionParser.ListEntry.class;
    }

    @Override
    public void setAttributeName(String attributeName) {
        this.attributeName = attributeName;
    }

    @Override
    protected void parseChild(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        Attr attribute = element.getAttributeNode(this.attributeName);
        if (null == attribute || StringUtils.isEmpty(attribute.getNodeValue())) {
            throw new IllegalStateException("No value for " + this.attributeName + " in " + SpringXMLUtils.elementToString(element));
        }
        String value = attribute.getNodeValue();
        builder.getRawBeanDefinition().setSource((Object)new ChildListEntryDefinitionParser.ListEntry(value));
        this.postProcess(parserContext, this.getBeanAssembler(element, builder), element);
    }
}

