/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.spring.parsers.processors;

import java.util.LinkedList;
import org.mule.runtime.config.spring.parsers.PreProcessor;
import org.mule.runtime.config.spring.parsers.assembly.configuration.PropertyConfiguration;
import org.mule.runtime.config.spring.util.SpringXMLUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;

public class CheckExclusiveAttributeAndText
implements PreProcessor {
    public static final int NONE = -1;
    private String attribute;

    public CheckExclusiveAttributeAndText(String attribute) {
        this.attribute = attribute;
    }

    @Override
    public void preProcess(PropertyConfiguration config, Element element) {
        LinkedList<String> foundAttributes = new LinkedList<String>();
        boolean found = false;
        NamedNodeMap attributes = element.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            String alias = SpringXMLUtils.attributeName((Attr)attributes.item(i));
            if (config.isIgnored(alias)) continue;
            if (this.attribute.equals(alias)) {
                found = true;
                continue;
            }
            foundAttributes.add(alias);
        }
        if (found && !element.getTextContent().isEmpty()) {
            StringBuilder message = new StringBuilder("The attribute '");
            message.append(this.attribute);
            message.append("' cannot be used with text content");
            message.append(" in element ");
            message.append(SpringXMLUtils.elementToString(element));
            message.append(".");
            throw new CheckExclusiveAttributeException(message.toString());
        }
    }

    public static class CheckExclusiveAttributeException
    extends IllegalStateException {
        private CheckExclusiveAttributeException(String message) {
            super(message);
        }
    }
}

