/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.spring.parsers.specific;

import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.config.spring.parsers.PreProcessor;
import org.mule.runtime.config.spring.parsers.assembly.configuration.PropertyConfiguration;
import org.mule.runtime.config.spring.parsers.delegate.ParentContextDefinitionParser;
import org.mule.runtime.config.spring.parsers.generic.ChildDefinitionParser;
import org.mule.runtime.config.spring.parsers.generic.MuleOrphanDefinitionParser;
import org.mule.runtime.core.config.i18n.CoreMessages;
import org.w3c.dom.Element;

public class ExceptionStrategyDefinitionParser
extends ParentContextDefinitionParser {
    public ExceptionStrategyDefinitionParser(Class exceptionStrategyClass) {
        super("mule", ExceptionStrategyDefinitionParser.createRootDefinitionParser(exceptionStrategyClass));
        this.otherwise(this.createInFlowServiceDefinitionParser(exceptionStrategyClass));
    }

    private ChildDefinitionParser createInFlowServiceDefinitionParser(Class exceptionStrategyClass) {
        ChildDefinitionParser exceptionListenerDefinitionParser = new ChildDefinitionParser("exceptionListener", exceptionStrategyClass, false);
        exceptionListenerDefinitionParser.registerPreProcessor(ExceptionStrategyDefinitionParser.createNoNameAttributePreProcessor());
        return exceptionListenerDefinitionParser;
    }

    static PreProcessor createNoNameAttributePreProcessor() {
        return new PreProcessor(){

            @Override
            public void preProcess(PropertyConfiguration config, Element element) {
                if (element.hasAttribute("name")) {
                    throw new MuleRuntimeException(CoreMessages.createStaticMessage("name attribute on exception strategy is only allowed on global exception strategies"));
                }
            }
        };
    }

    public static MuleOrphanDefinitionParser createRootDefinitionParser(Class exceptionStrategyClass) {
        MuleOrphanDefinitionParser globalExceptionStrategyDefinitionParser = exceptionStrategyClass == null ? new MuleOrphanDefinitionParser(false) : new MuleOrphanDefinitionParser(exceptionStrategyClass, false);
        globalExceptionStrategyDefinitionParser.addIgnored("name");
        return globalExceptionStrategyDefinitionParser;
    }
}

