/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.spring.processors;

import java.util.Map;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.context.MuleContextAware;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.PlaceholderConfigurerSupport;
import org.springframework.context.ApplicationContext;

public class ParentContextPropertyPlaceholderProcessor
implements MuleContextAware,
BeanFactoryPostProcessor {
    private MuleContext muleContext;

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        ApplicationContext applicationContext = (ApplicationContext)this.muleContext.getRegistry().lookupObject("springApplicationContext");
        ApplicationContext domainContext = applicationContext.getParent();
        if (domainContext != null) {
            Map propertySourcesPlaceholderConfigurerMap = domainContext.getBeansOfType(PlaceholderConfigurerSupport.class);
            for (PlaceholderConfigurerSupport propertySourcesPlaceholderConfigurer : propertySourcesPlaceholderConfigurerMap.values()) {
                propertySourcesPlaceholderConfigurer.postProcessBeanFactory(beanFactory);
            }
        }
    }

    @Override
    public void setMuleContext(MuleContext muleContext) {
        this.muleContext = muleContext;
    }
}

