/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.api.client;

import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.MessageExchangePattern;
import org.mule.runtime.core.api.client.OperationOptions;

public class RequestCacheKey<OptionsType extends OperationOptions> {
    private final String url;
    private final OptionsType operationOptions;
    private final MessageExchangePattern exchangePattern;

    public RequestCacheKey(String url, OptionsType operationOptions, MessageExchangePattern exchangePattern) {
        Preconditions.checkArgument(url != null, "URL cannot be null");
        Preconditions.checkArgument(operationOptions != null, "Operation options cannot be null");
        Preconditions.checkArgument(exchangePattern != null, "Exchange pattern cannot be null");
        this.url = url;
        this.operationOptions = operationOptions;
        this.exchangePattern = exchangePattern;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RequestCacheKey)) {
            return false;
        }
        RequestCacheKey that = (RequestCacheKey)o;
        if (!this.operationOptions.equals(that.operationOptions)) {
            return false;
        }
        if (!this.url.equals(that.url)) {
            return false;
        }
        return this.exchangePattern == that.exchangePattern;
    }

    public int hashCode() {
        int result = this.url.hashCode();
        result = 31 * result + this.operationOptions.hashCode();
        result = 31 * result + this.exchangePattern.hashCode();
        return result;
    }

    public String getUrl() {
        return this.url;
    }

    public OptionsType getOperationOptions() {
        return this.operationOptions;
    }

    public MessageExchangePattern getExchangePattern() {
        return this.exchangePattern;
    }
}

