/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.execution;

import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.execution.ExecutionCallback;
import org.mule.runtime.core.exception.MessagingException;
import org.mule.runtime.core.execution.ExecutionContext;
import org.mule.runtime.core.execution.ExecutionInterceptor;
import org.mule.runtime.core.transaction.TransactionCoordination;

class CommitTransactionInterceptor
implements ExecutionInterceptor<Event> {
    private final ExecutionInterceptor<Event> nextInterceptor;

    public CommitTransactionInterceptor(ExecutionInterceptor<Event> nextInterceptor) {
        this.nextInterceptor = nextInterceptor;
    }

    @Override
    public Event execute(ExecutionCallback<Event> callback, ExecutionContext executionContext) throws Exception {
        Event result = this.nextInterceptor.execute(callback, executionContext);
        if (executionContext.needsTransactionResolution()) {
            try {
                TransactionCoordination.getInstance().resolveTransaction();
            }
            catch (Exception e) {
                if (result == null) {
                    result = Event.getCurrentEvent();
                }
                throw new MessagingException(result, (Throwable)e);
            }
        }
        return result;
    }
}

