/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.streaming.object;

import java.io.IOException;
import java.util.NoSuchElementException;
import org.mule.runtime.api.streaming.object.CursorIteratorProvider;
import org.mule.runtime.core.internal.streaming.AbstractCursorIterator;
import org.mule.runtime.core.internal.streaming.object.Bucket;
import org.mule.runtime.core.internal.streaming.object.ObjectStreamBuffer;
import org.mule.runtime.core.internal.streaming.object.Position;

public class BufferedCursorIterator<T>
extends AbstractCursorIterator<T> {
    private final ObjectStreamBuffer<T> buffer;
    private Bucket<T> bucket = null;

    public BufferedCursorIterator(ObjectStreamBuffer<T> buffer, CursorIteratorProvider provider) {
        super(provider);
        this.buffer = buffer;
    }

    @Override
    public boolean hasNext() {
        return this.buffer.hasNext(this.getPosition());
    }

    @Override
    protected T doNext(long p) {
        Position position = this.buffer.toPosition(p);
        if (this.bucket == null || !this.bucket.contains(position)) {
            this.bucket = this.buffer.getBucketFor(position).orElse(this.bucket);
        }
        if (this.bucket != null) {
            return this.bucket.get(position.getItemIndex()).orElseThrow(NoSuchElementException::new);
        }
        throw new NoSuchElementException();
    }

    @Override
    public void release() {
        this.bucket = null;
    }

    @Override
    protected void doClose() throws IOException {
    }

    @Override
    public int getSize() {
        return this.buffer.getSize();
    }
}

