/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.streaming.object;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.mule.runtime.api.streaming.exception.StreamingBufferSizeExceededException;
import org.mule.runtime.core.internal.streaming.object.AbstractObjectStreamBuffer;
import org.mule.runtime.core.internal.streaming.object.Bucket;
import org.mule.runtime.core.internal.streaming.object.Position;
import org.mule.runtime.core.internal.streaming.object.iterator.StreamingIterator;
import org.mule.runtime.core.streaming.object.InMemoryCursorIteratorConfig;

public class InMemoryObjectStreamBuffer<T>
extends AbstractObjectStreamBuffer<T> {
    private final InMemoryCursorIteratorConfig config;
    private List<Bucket<T>> buckets;

    public InMemoryObjectStreamBuffer(StreamingIterator<T> stream, InMemoryCursorIteratorConfig config) {
        super(stream);
        this.config = config;
    }

    @Override
    protected void doClose() {
        this.buckets.clear();
    }

    @Override
    public Position toPosition(long position) {
        int initialBufferSize = this.config.getInitialBufferSize();
        int bucketsDelta = this.config.getBufferSizeIncrement();
        if (position < (long)initialBufferSize || bucketsDelta == 0) {
            return new Position(0, (int)position);
        }
        long offset = position - (long)initialBufferSize;
        int bucketIndex = (int)Math.floor(offset / (long)bucketsDelta) + 1;
        int itemIndex = (int)position - (initialBufferSize + (bucketIndex - 1) * bucketsDelta);
        return new Position(bucketIndex, itemIndex);
    }

    @Override
    protected void initialize(Optional<Position> maxPosition, Bucket<T> initialBucket) {
        this.buckets = maxPosition.map(p -> new ArrayList(p.getBucketIndex())).orElseGet(ArrayList::new);
        initialBucket = new Bucket(0, this.config.getInitialBufferSize());
        this.buckets.add(initialBucket);
        this.setCurrentBucket(initialBucket);
    }

    @Override
    protected Optional<Bucket<T>> getPresentBucket(Position position) {
        if (position.getBucketIndex() < this.buckets.size()) {
            return Optional.ofNullable(this.buckets.get(position.getBucketIndex()));
        }
        return Optional.empty();
    }

    @Override
    protected Bucket<T> onBucketOverflow(Bucket<T> overflownBucket) {
        Bucket newBucket = new Bucket(overflownBucket.getIndex() + 1, this.config.getBufferSizeIncrement());
        this.buckets.add(newBucket);
        return newBucket;
    }

    @Override
    protected void validateMaxBufferSizeNotExceeded(int instancesCount) {
        if (instancesCount > this.config.getMaxBufferSize()) {
            throw new StreamingBufferSizeExceededException(this.config.getMaxBufferSize());
        }
    }
}

