/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.transformer.compression;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.streaming.bytes.CursorStreamProvider;
import org.mule.runtime.core.api.serialization.SerializationException;
import org.mule.runtime.core.api.transformer.TransformerException;
import org.mule.runtime.core.api.util.compression.AbstractCompressionTransformer;
import org.mule.runtime.core.api.util.compression.GZipCompression;

public class GZipUncompressTransformer
extends AbstractCompressionTransformer {
    public GZipUncompressTransformer() {
        this.setStrategy(new GZipCompression());
        this.registerSourceType(DataType.BYTE_ARRAY);
        this.registerSourceType(DataType.INPUT_STREAM);
        this.registerSourceType(DataType.CURSOR_STREAM_PROVIDER);
        this.setReturnDataType(DataType.OBJECT);
    }

    @Override
    public Object doTransform(Object src, Charset outputEncoding) throws TransformerException {
        try {
            if (src instanceof CursorStreamProvider) {
                return this.getStrategy().uncompressInputStream((InputStream)((CursorStreamProvider)src).openCursor());
            }
            if (src instanceof InputStream) {
                return this.getStrategy().uncompressInputStream((InputStream)src);
            }
            byte[] buffer = this.getStrategy().uncompressByteArray((byte[])src);
            DataType returnDataType = this.getReturnDataType();
            if (DataType.STRING.isCompatibleWith(returnDataType)) {
                return new String(buffer, outputEncoding);
            }
            if (!DataType.OBJECT.isCompatibleWith(returnDataType) && !DataType.BYTE_ARRAY.isCompatibleWith(returnDataType)) {
                try {
                    return this.muleContext.getObjectSerializer().getExternalProtocol().deserialize(buffer);
                }
                catch (SerializationException e) {
                    throw new TransformerException(this, (Throwable)e);
                }
            }
            try {
                return this.muleContext.getObjectSerializer().getExternalProtocol().deserialize(buffer);
            }
            catch (SerializationException e) {
                return buffer;
            }
        }
        catch (IOException e) {
            throw new TransformerException(I18nMessageFactory.createStaticMessage("Failed to uncompress message."), this, (Throwable)e);
        }
    }
}

