/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.routing.filters;

import org.mule.runtime.api.message.Message;
import org.mule.runtime.core.PropertyScope;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.routing.filter.Filter;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.core.api.util.StringUtils;
import org.mule.runtime.core.internal.message.InternalMessage;
import org.mule.runtime.core.routing.filters.WildcardFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessagePropertyFilter
implements Filter {
    protected final transient Logger logger = LoggerFactory.getLogger(MessagePropertyFilter.class);
    private boolean caseSensitive = true;
    private boolean not = false;
    private String propertyName;
    private String propertyValue;
    private PropertyScope scope = PropertyScope.OUTBOUND;
    private WildcardFilter wildcardFilter;

    public MessagePropertyFilter() {
    }

    public MessagePropertyFilter(String expression) {
        this.setPattern(expression);
    }

    @Override
    public boolean accept(Message message, Event.Builder builder) {
        if (message == null) {
            return false;
        }
        Object value = this.scope.equals(PropertyScope.INBOUND) ? ((InternalMessage)message).getInboundProperty(this.propertyName) : ((InternalMessage)message).getOutboundProperty(this.propertyName);
        boolean match = value == null ? this.compare(null, this.propertyValue) : this.compare(value.toString(), this.propertyValue);
        if (!match && this.logger.isDebugEnabled()) {
            this.logger.debug(String.format("Property: '%s' not found in scope '%s'. Message %n%s", this.propertyName, this.scope, message));
        }
        return match;
    }

    protected boolean compare(String value1, String value2) {
        if (value1 == null && value2 != null && !"null".equals(value2) && this.not) {
            return true;
        }
        if (value1 == null) {
            value1 = "null";
        }
        boolean result = this.wildcardFilter.accept(value1);
        return this.not ? !result : result;
    }

    public String getPattern() {
        return this.propertyName + '=' + this.propertyValue;
    }

    public void setPattern(String expression) {
        int x = expression.indexOf(":");
        int i = expression.indexOf(61);
        if (i == -1) {
            throw new IllegalArgumentException("Pattern is malformed - it should be a key value pair, i.e. property=value: " + expression);
        }
        if (x > -1 && x < i) {
            this.setScope(expression.substring(0, x));
            expression = expression.substring(x + 1);
            i = expression.indexOf(61);
        }
        if (expression.charAt(i - 1) == '!') {
            this.not = true;
            this.propertyName = expression.substring(0, i - 1).trim();
        } else {
            this.propertyName = expression.substring(0, i).trim();
        }
        this.propertyValue = expression.substring(i + 1).trim();
        this.wildcardFilter = new WildcardFilter(this.propertyValue);
        this.wildcardFilter.setCaseSensitive(this.isCaseSensitive());
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public void setCaseSensitive(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
        if (this.wildcardFilter != null) {
            this.wildcardFilter.setCaseSensitive(caseSensitive);
        }
    }

    public String getScope() {
        return this.scope.getName();
    }

    public void setScope(String scope) {
        if (StringUtils.isBlank(scope)) {
            return;
        }
        PropertyScope ps = PropertyScope.valueOf(scope.toUpperCase().trim());
        if (ps == null) {
            throw new IllegalArgumentException(String.format("'%s' is not a valid property scope.", scope));
        }
        this.scope = ps;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        MessagePropertyFilter other = (MessagePropertyFilter)obj;
        return ClassUtils.equal(this.propertyName, other.propertyName) && ClassUtils.equal(this.propertyValue, other.propertyValue) && ClassUtils.equal(this.scope, other.scope) && this.caseSensitive == other.caseSensitive;
    }

    public int hashCode() {
        return ClassUtils.hash(new Object[]{this.getClass(), this.propertyName, this.propertyValue, this.scope, this.caseSensitive});
    }
}

