/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.transformer.simple;

import java.io.InputStream;
import java.nio.charset.Charset;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.streaming.bytes.CursorStreamProvider;
import org.mule.runtime.core.api.transformer.TransformerException;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.runtime.core.api.util.StringUtils;
import org.mule.runtime.core.transformer.AbstractTransformer;

public class StringToObjectArray
extends AbstractTransformer {
    private String delimiter = null;
    private static final String DEFAULT_DELIMITER = " ";

    public StringToObjectArray() {
        this.registerSourceType(DataType.STRING);
        this.registerSourceType(DataType.BYTE_ARRAY);
        this.registerSourceType(DataType.INPUT_STREAM);
        this.registerSourceType(DataType.CURSOR_STREAM_PROVIDER);
        this.setReturnDataType(DataType.fromType(Object[].class));
    }

    @Override
    public Object doTransform(Object src, Charset outputEncoding) throws TransformerException {
        String in = src instanceof byte[] ? this.createStringFromByteArray((byte[])src, outputEncoding) : (src instanceof CursorStreamProvider ? this.createStringFromInputStream((InputStream)((CursorStreamProvider)src).openCursor()) : (src instanceof InputStream ? this.createStringFromInputStream((InputStream)src) : (String)src));
        String[] out = StringUtils.splitAndTrim(in, this.getDelimiter());
        return out;
    }

    protected String createStringFromByteArray(byte[] bytes, Charset outputEncoding) throws TransformerException {
        return new String(bytes, outputEncoding);
    }

    protected String createStringFromInputStream(InputStream input) {
        try {
            String string = IOUtils.toString(input);
            return string;
        }
        finally {
            IOUtils.closeQuietly(input);
        }
    }

    public String getDelimiter() {
        if (this.delimiter == null) {
            return DEFAULT_DELIMITER;
        }
        return this.delimiter;
    }

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }
}

