/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.api.declaration.type;

import org.mule.metadata.api.annotation.TypeAliasAnnotation;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.ObjectTypeBuilder;
import org.mule.metadata.api.builder.TypeBuilder;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.extension.api.declaration.type.InfrastructureTypeBuilder;
import org.mule.runtime.extension.api.declaration.type.annotation.InfrastructureTypeAnnotation;

public final class ReconnectionStrategyTypeBuilder
extends InfrastructureTypeBuilder {
    public static final String COUNT = "count";
    public static final String FREQUENCY = "frequency";
    public static final String RECONNECT_ALIAS = "reconnect";
    public static final String RECONNECT_FOREVER_ALIAS = "reconnect-forever";
    public static final String BLOCKING = "blocking";
    public static final String RECONNECTION_STRATEGY = "ReconnectionStrategy";

    public MetadataType buildReconnectionStrategyType() {
        BaseTypeBuilder typeBuilder = BaseTypeBuilder.create(MetadataFormat.JAVA);
        return BaseTypeBuilder.create(MetadataFormat.JAVA).unionType().of(this.getSimpleRetryType(typeBuilder)).of(this.getForeverRetryType(typeBuilder)).id(Object.class.getName()).with(new TypeAliasAnnotation(RECONNECTION_STRATEGY)).with(new InfrastructureTypeAnnotation()).build();
    }

    private TypeBuilder getSimpleRetryType(BaseTypeBuilder typeBuilder) {
        ObjectTypeBuilder retryType = typeBuilder.objectType().id(Object.class.getName()).with(new InfrastructureTypeAnnotation()).with(new TypeAliasAnnotation(RECONNECT_ALIAS));
        this.addFrequencyField(retryType, typeBuilder);
        this.addIntField(retryType, typeBuilder, COUNT, "How many reconnection attempts to make", 2);
        this.addBlockingField(retryType, typeBuilder);
        return retryType;
    }

    private void addFrequencyField(ObjectTypeBuilder retryType, BaseTypeBuilder typeBuilder) {
        this.addLongField(retryType, typeBuilder, FREQUENCY, "How often (in ms) to reconnect", 2000L);
    }

    private TypeBuilder getForeverRetryType(BaseTypeBuilder typeBuilder) {
        ObjectTypeBuilder retryType = typeBuilder.objectType().id(Object.class.getName()).with(new InfrastructureTypeAnnotation()).with(new TypeAliasAnnotation(RECONNECT_FOREVER_ALIAS));
        this.addFrequencyField(retryType, typeBuilder);
        return retryType;
    }

    private void addBlockingField(ObjectTypeBuilder retryType, BaseTypeBuilder typeBuilder) {
        this.addBooleanField(retryType, typeBuilder, BLOCKING, "If false, the reconnection strategy will run in a separate, non-blocking thread", true);
    }
}

