/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.api.model.operation;

import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.mule.runtime.api.meta.model.ModelProperty;
import org.mule.runtime.api.meta.model.Stereotype;
import org.mule.runtime.api.meta.model.display.DisplayModel;
import org.mule.runtime.api.meta.model.operation.RouteModel;
import org.mule.runtime.api.meta.model.parameter.ParameterGroupModel;
import org.mule.runtime.extension.api.model.parameter.AbstractParameterizedModel;

public class ImmutableRouteModel
extends AbstractParameterizedModel
implements RouteModel {
    private int minOccurs;
    private Integer maxOccurs;
    private Set<Stereotype> allowedStereotypes;

    public ImmutableRouteModel(String name, String description, int minOccurs, Integer maxOccurs, Set<Stereotype> allowedStereotypes, List<ParameterGroupModel> parameterGroupModels, DisplayModel displayModel, Set<ModelProperty> modelProperties) {
        super(name, description, parameterGroupModels, displayModel, modelProperties);
        ImmutableRouteModel.checkArgument(minOccurs >= 0, "minOccurs has to be greater or equal to zero");
        if (maxOccurs != null) {
            ImmutableRouteModel.checkArgument(maxOccurs >= 1, "maxOccurs has to be greater or equal to 1");
        }
        this.minOccurs = minOccurs;
        this.maxOccurs = maxOccurs;
        this.allowedStereotypes = allowedStereotypes != null && !allowedStereotypes.isEmpty() ? this.copy(allowedStereotypes) : null;
    }

    @Override
    public int getMinOccurs() {
        return this.minOccurs;
    }

    @Override
    public Optional<Integer> getMaxOccurs() {
        return Optional.ofNullable(this.maxOccurs);
    }

    @Override
    public Optional<Set<Stereotype>> getAllowedStereotypes() {
        return Optional.ofNullable(this.allowedStereotypes);
    }
}

