/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.deployment.impl.internal.application;

import java.io.File;
import java.net.MalformedURLException;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.model.Build;
import org.apache.maven.model.Model;
import org.apache.maven.model.Plugin;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.mule.maven.client.api.LocalRepositorySupplierFactory;
import org.mule.maven.client.api.MavenClient;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.config.bootstrap.ArtifactType;
import org.mule.runtime.module.artifact.descriptor.BundleDependency;
import org.mule.runtime.module.artifact.descriptor.ClassLoaderModel;
import org.mule.runtime.module.artifact.util.FileJarExplorer;
import org.mule.runtime.module.artifact.util.JarInfo;
import org.mule.runtime.module.deployment.impl.internal.maven.AbstractMavenClassLoaderModelLoader;
import org.mule.runtime.module.deployment.impl.internal.maven.MavenUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeployableMavenClassLoaderModelLoader
extends AbstractMavenClassLoaderModelLoader {
    public static final String ADD_TEST_DEPENDENCIES_KEY = "mule.embedded.maven.addTestDependenciesToAppClassPath";
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());

    public DeployableMavenClassLoaderModelLoader(MavenClient mavenClient, LocalRepositorySupplierFactory localRepositorySupplierFactory) {
        super(mavenClient, localRepositorySupplierFactory);
    }

    @Override
    public String getId() {
        return "maven";
    }

    @Override
    protected void addArtifactSpecificClassloaderConfiguration(File artifactFile, ClassLoaderModel.ClassLoaderModelBuilder classLoaderModelBuilder, Set<BundleDependency> dependencies) {
        try {
            classLoaderModelBuilder.containing(new File(artifactFile, "classes").toURL());
            this.exportSharedLibrariesResourcesAndPackages(artifactFile, classLoaderModelBuilder, dependencies);
        }
        catch (MalformedURLException e) {
            throw new MuleRuntimeException(e);
        }
    }

    private void exportSharedLibrariesResourcesAndPackages(File applicationFolder, ClassLoaderModel.ClassLoaderModelBuilder classLoaderModelBuilder, Set<BundleDependency> dependencies) {
        List plugins;
        Model model = this.loadPomModel(applicationFolder);
        Build build = model.getBuild();
        if (build != null && (plugins = build.getPlugins()) != null) {
            Optional<Plugin> packagingPluginOptional = plugins.stream().filter(plugin -> plugin.getArtifactId().equals("mule-maven-plugin") && plugin.getGroupId().equals("org.mule.tools.maven")).findFirst();
            packagingPluginOptional.ifPresent(packagingPlugin -> {
                Xpp3Dom[] sharedLibraries;
                Xpp3Dom sharedLibrariesDom;
                Object configuration = packagingPlugin.getConfiguration();
                if (configuration != null && (sharedLibrariesDom = ((Xpp3Dom)configuration).getChild("sharedLibraries")) != null && (sharedLibraries = sharedLibrariesDom.getChildren("sharedLibrary")) != null) {
                    FileJarExplorer fileJarExplorer = new FileJarExplorer();
                    for (Xpp3Dom sharedLibrary : sharedLibraries) {
                        String groupId = this.getSharedLibraryAttribute(applicationFolder, sharedLibrary, "groupId");
                        String artifactId = this.getSharedLibraryAttribute(applicationFolder, sharedLibrary, "artifactId");
                        Optional<BundleDependency> bundleDependencyOptional = dependencies.stream().filter(bundleDependency -> bundleDependency.getDescriptor().getArtifactId().equals(artifactId) && bundleDependency.getDescriptor().getGroupId().equals(groupId)).findFirst();
                        bundleDependencyOptional.map(bundleDependency -> {
                            JarInfo jarInfo = fileJarExplorer.explore(bundleDependency.getBundleUri());
                            classLoaderModelBuilder.exportingPackages(jarInfo.getPackages());
                            classLoaderModelBuilder.exportingResources(jarInfo.getResources());
                            return bundleDependency;
                        }).orElseThrow(() -> new MuleRuntimeException(I18nMessageFactory.createStaticMessage(String.format("Dependency %s:%s could not be found within the artifact %s. It must be declared within the maven dependencies of the artifact.", groupId, artifactId, applicationFolder.getName()))));
                    }
                }
            });
        }
    }

    private String getSharedLibraryAttribute(File applicationFolder, Xpp3Dom sharedLibraryDom, String attributeName) {
        Xpp3Dom attributeDom = sharedLibraryDom.getChild(attributeName);
        Preconditions.checkState(attributeDom != null, String.format("%s element was not defined within the shared libraries declared in the pom file of the artifact %s", attributeName, applicationFolder.getName()));
        String attributeValue = attributeDom.getValue().trim();
        Preconditions.checkState(!StringUtils.isEmpty((String)attributeValue), String.format("%s was defined but has an empty value within the shared libraries declared in the pom file of the artifact %s", attributeName, applicationFolder.getName()));
        return attributeValue;
    }

    @Override
    protected boolean enabledTestDependencies() {
        return Boolean.getBoolean(ADD_TEST_DEPENDENCIES_KEY);
    }

    @Override
    protected Model loadPomModel(File artifactFile) {
        return MavenUtils.getPomModelFolder(artifactFile);
    }

    @Override
    public boolean supportsArtifactType(ArtifactType artifactType) {
        return artifactType.equals((Object)ArtifactType.APP) || artifactType.equals((Object)ArtifactType.POLICY);
    }
}

