/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.deployment.impl.internal.policy;

import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.extension.ExtensionManager;
import org.mule.runtime.extension.api.runtime.ConfigurationInstance;
import org.mule.runtime.extension.api.runtime.ConfigurationProvider;

public class CompositeArtifactExtensionManager
implements ExtensionManager {
    private final ExtensionManager parentExtensionManager;
    private final ExtensionManager childExtensionManager;
    private final Set<ExtensionModel> extensionModels;

    public CompositeArtifactExtensionManager(ExtensionManager parentExtensionManager, ExtensionManager childExtensionManager) {
        Preconditions.checkArgument(parentExtensionManager != null, "parentExtensionManager cannot be null");
        Preconditions.checkArgument(childExtensionManager != null, "childExtensionManager cannot be null");
        this.parentExtensionManager = parentExtensionManager;
        this.childExtensionManager = childExtensionManager;
        this.extensionModels = new HashSet<ExtensionModel>();
        this.extensionModels.addAll(parentExtensionManager.getExtensions());
        this.extensionModels.addAll(childExtensionManager.getExtensions());
    }

    @Override
    public void registerExtension(ExtensionModel extensionModel) {
        throw new UnsupportedOperationException("Composite extension manager cannot register extensions");
    }

    @Override
    public Set<ExtensionModel> getExtensions() {
        return this.extensionModels;
    }

    @Override
    public Optional<ExtensionModel> getExtension(String extensionName) {
        return this.extensionModels.stream().filter(extensionModel -> extensionModel.getName().equals(extensionName)).findFirst();
    }

    @Override
    public ConfigurationInstance getConfiguration(String configurationProviderName, Event event) {
        return this.getConfigurationProvider(configurationProviderName).map(provider -> provider.get(event)).orElseThrow(() -> new IllegalArgumentException(String.format("There is no registered configurationProvider under name '%s'", configurationProviderName)));
    }

    @Override
    public Optional<ConfigurationInstance> getConfiguration(ExtensionModel extensionModel, ComponentModel componentModel, Event event) {
        Optional<ConfigurationProvider> provider = this.getConfigurationProvider(extensionModel, componentModel);
        if (provider.isPresent()) {
            return Optional.ofNullable(provider.get().get(event));
        }
        throw new IllegalArgumentException(String.format("There is no registered configuration provider for extension '%s'", extensionModel.getName()));
    }

    @Override
    public Optional<ConfigurationProvider> getConfigurationProvider(String configurationProviderName) {
        Optional<ConfigurationProvider> configurationProvider = this.childExtensionManager.getConfigurationProvider(configurationProviderName);
        if (!configurationProvider.isPresent()) {
            configurationProvider = this.parentExtensionManager.getConfigurationProvider(configurationProviderName);
        }
        return configurationProvider;
    }

    @Override
    public Optional<ConfigurationProvider> getConfigurationProvider(ExtensionModel extensionModel, ComponentModel componentModel) {
        Optional<ConfigurationProvider> configurationModel = this.childExtensionManager.getConfigurationProvider(extensionModel, componentModel);
        if (!configurationModel.isPresent()) {
            configurationModel = this.parentExtensionManager.getConfigurationProvider(extensionModel, componentModel);
        }
        return configurationModel;
    }

    @Override
    public void registerConfigurationProvider(ConfigurationProvider configurationProvider) {
        throw new UnsupportedOperationException("Composite extension manager cannot register extension providers");
    }

    public ExtensionManager getParentExtensionManager() {
        return this.parentExtensionManager;
    }

    public ExtensionManager getChildExtensionManager() {
        return this.childExtensionManager;
    }
}

