/*
 * Decompiled with CFR 0.152.
 */
package org.mule.metadata.java.api.utils;

import java.util.Optional;
import org.apache.commons.lang3.ClassUtils;
import org.mule.metadata.api.ClassTypeLoader;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.NullType;
import org.mule.metadata.api.model.VoidType;
import org.mule.metadata.api.utils.MetadataTypeUtils;
import org.mule.metadata.java.api.annotation.ClassInformationAnnotation;

public final class JavaTypeUtils {
    private JavaTypeUtils() {
    }

    public static <T> Class<T> getType(MetadataType metadataType) {
        return JavaTypeUtils.getType(metadataType, Thread.currentThread().getContextClassLoader());
    }

    public static <T> Class<T> getType(MetadataType metadataType, ClassLoader classLoader) {
        if (metadataType instanceof NullType || metadataType instanceof VoidType) {
            return Void.TYPE;
        }
        Optional<String> typeId = MetadataTypeUtils.getTypeId(metadataType);
        if (!typeId.isPresent()) {
            throw new IllegalArgumentException("metadataType does not contain a type annotation");
        }
        try {
            return ClassUtils.getClass((ClassLoader)classLoader, (String)typeId.get(), (boolean)true);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Could not load class " + typeId.get(), e);
        }
    }

    public static Optional<MetadataType> getGenericTypeAt(MetadataType metadataType, int index, ClassTypeLoader typeLoader) {
        Optional<ClassInformationAnnotation> classInformationAnnotation = metadataType.getAnnotation(ClassInformationAnnotation.class);
        if (!classInformationAnnotation.isPresent() || classInformationAnnotation.get().getGenericTypes().size() <= index) {
            return Optional.empty();
        }
        return typeLoader.load(classInformationAnnotation.get().getGenericTypes().get(index));
    }
}

